% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/old_taxa--taxonomy--docs.R
\name{get_data}
\alias{get_data}
\title{Get data in a taxmap object by name}
\arguments{
\item{obj}{A [taxonomy()] or [taxmap()]  object}

\item{name}{(`character`) Names of data to return. If not supplied, return
all data listed in [all_names()].}

\item{...}{Passed to [all_names()]. Used to filter what kind of data is
returned (e.g. columns in tables or function output?) if `name` is not
supplied or what kinds are allowed if `name` is supplied.}
}
\value{
`list` of vectors or lists. Each vector or list will be named by
  associated taxon ids if possible.
}
\description{
Given a vector of names, return a list of data (usually lists/vectors)
contained in a [taxonomy()] or [taxmap()] object. Each item will be named by
taxon ids when possible.
\preformatted{
obj$get_data(name = NULL, ...)
get_data(obj, name = NULL, ...)}
}
\examples{
# Get specific values
get_data(ex_taxmap, c("reaction", "n_legs", "taxon_ranks"))

# Get all values
get_data(ex_taxmap)

}
\seealso{
Other NSE helpers: 
\code{\link{all_names}()},
\code{\link{data_used}},
\code{\link{names_used}}
}
\concept{NSE helpers}
