% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/old_taxa--taxonomy--docs.R
\name{map_data}
\alias{map_data}
\title{Create a mapping between two variables}
\arguments{
\item{obj}{The [taxonomy()] or [taxmap()] object.}

\item{from}{The value used to name the output. There will be one output value
for each value in `from`. Any variable that appears in [all_names()] can be
used as if it was a variable on its own.}

\item{to}{The value returned in the output. Any variable that appears in
[all_names()] can be used as if it was a variable on its own.}

\item{warn}{If `TRUE`, issue a warning if there are multiple unique values of
`to` for each value of `from`.}
}
\value{
A vector of `to` values named by values in `from`.
}
\description{
Creates a named vector that maps the values of two variables associated with
taxa in a [taxonomy()] or [taxmap()] object. Both values must be named by
taxon ids.
\preformatted{
obj$map_data(from, to, warn = TRUE)
map_data(obj, from, to, warn = TRUE)}
}
\examples{
# Mapping between two variables in `all_names(ex_taxmap)`
map_data(ex_taxmap, from = taxon_names, to = n_legs > 0)

# Mapping with external variables
x = c("d" = "looks like a cat", "h" = "big scary cats",
      "i" = "smaller cats", "m" = "might eat you", "n" = "Meow! (Feed me!)")
map_data(ex_taxmap, from = taxon_names, to = x)

}
\seealso{
Other taxonomy data functions: 
\code{\link{classifications}()},
\code{\link{id_classifications}()},
\code{\link{is_branch}()},
\code{\link{is_internode}()},
\code{\link{is_leaf}()},
\code{\link{is_root}()},
\code{\link{is_stem}()},
\code{\link{map_data_}()},
\code{\link{n_leaves_1}()},
\code{\link{n_leaves}()},
\code{\link{n_subtaxa_1}()},
\code{\link{n_subtaxa}()},
\code{\link{n_supertaxa_1}()},
\code{\link{n_supertaxa}()},
\code{\link{taxon_ids}()},
\code{\link{taxon_indexes}()},
\code{\link{taxon_names}()},
\code{\link{taxon_ranks}()}
}
\concept{taxonomy data functions}
