% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readingandfes.R
\name{fes}
\alias{fes}
\title{Calculate free energy surface by Bias Sum algorithm}
\usage{
fes(hills, imin = 1, imax = NULL, xlim = NULL, ylim = NULL,
  npoints = 256)
}
\arguments{
\item{hills}{hillsfile object.}

\item{imin}{index of a hill from which summation starts (default 1).}

\item{imax}{index of a hill from which summation stops (default the rest of hills).}

\item{xlim}{numeric vector of length 2, giving the CV1 coordinates range.}

\item{ylim}{numeric vector of length 2, giving the CV2 coordinates range.}

\item{npoints}{resolution of the free energy surface in number of points.}
}
\value{
fes object.
}
\description{
`fes` sums up hills using fast Bias Sum algorithm.
}
\examples{
tfes<-fes(acealanme, imax=5000)
}
