% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metalite_table1.R
\name{metalite_table1}
\alias{metalite_table1}
\title{Interactive Table of Descriptive Statistics in HTML}
\usage{
metalite_table1(
  formula,
  data,
  id,
  var_listing = NULL,
  total = TRUE,
  download = "none",
  type = NULL
)
}
\arguments{
\item{formula}{an object of class "formula".}

\item{data}{a data frame that contain variables described in the \code{formula}.}

\item{id}{a character value to indicate subject/record id variable name in \code{data}.}

\item{var_listing}{a character vector of additional variables included in the drill down listing.}

\item{total}{a logical value to display or hide "Total" column.}

\item{download}{a character value to enable download button. Allowed values include
"none", "listing", "table", and 'all'.}

\item{type}{a character value to control section title (e.g. "Subjects", "Records").}
}
\value{
a \code{shiny.tag.list} object that contain a \code{reactable} HTML widget for
interactive table of describptive statistics.
}
\description{
Interactive Table of Descriptive Statistics in HTML
}
\examples{
if (interactive()) {
  metalite_table1(~ AGE + SEX | TRT01A, data = r2rtf::r2rtf_adsl, id = "SUBJID")
}

}
