% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uvmeta.r
\name{plot.uvmeta}
\alias{plot.uvmeta}
\title{Forest Plots}
\usage{
\method{plot}{uvmeta}(x, sort = "asc", ...)
}
\arguments{
\item{x}{An object of class \code{"uvmeta"}}

\item{sort}{By default, studies are ordered by ascending effect size (\code{sort="asc"}). For study ordering by descending
effect size, choose \code{sort="desc"}. For any other value, study ordering is ignored.}

\item{\dots}{Additional arguments which are passed to \link{forest}.}
}
\description{
Function to create forest plots for objects of class \code{"uvmeta"}.
}
\details{
The forest plot shows the performance estimates of each validation with corresponding confidence 
intervals. A polygon is added to the bottom of the forest plot, showing the summary estimate based on the model. 
A 95\% prediction interval is added by default for random-effects models,  the dotted line indicates its (approximate) bounds
}
\note{
Full lines indicate confidence intervals or credibility intervals (in case of a Bayesian meta-analysis). Dashed
lines indicate prediction intervals. The width of all intervals is defined by the significance level chosen during 
meta-analysis.
}
\examples{
data(Roberts)

# Frequentist random-effects meta-analysis
fit <- with(Roberts, uvmeta(r=SDM, r.se=SE, labels=rownames(Roberts)))
plot(fit) 

}
\references{
\itemize{
\item Lewis S, Clarke M. Forest plots: trying to see the wood and the trees. \emph{BMJ}. 2001; 322(7300):1479--80.
\item Riley RD, Higgins JPT, Deeks JJ. Interpretation of random effects meta-analyses. \emph{BMJ}. 2011 342:d549--d549.
}
}
\author{
Thomas Debray <thomas.debray@gmail.com>
}
\keyword{forest}
\keyword{meta-analysis}
