% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{stars_pval}
\alias{stars_pval}
\title{Generate significance stars from p-values}
\usage{
stars_pval(p_value)
}
\arguments{
\item{p_value}{A numeric vector of p-values}
}
\value{
A character vector containing the same number of elements as p-value,
with an attribute "legend" providing the conversion pattern.
}
\description{
Generate significance stars from p-values using R's standard definitions.
}
\details{
Mapping from p_value ranges to symbols:
\itemize{
\item \strong{0 - 0.0001}: '****'
\item \strong{0.0001 - 0.001}: '***'
\item \strong{0.001 - 0.01}: '**'
\item \strong{0.01 - 0.05}: '*'
\item \strong{0.05 - 1.0}: 'ns'
}
}
\examples{
\donttest{
p_vals <- c(0.01, 0.043, 0.1, 0.0023, 0.000012)
stars_pval(p_vals)
}

}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
