% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Smith_Hazel.R
\name{Smith_Hazel}
\alias{Smith_Hazel}
\title{Smith-Hazel index}
\usage{
Smith_Hazel(
  .data,
  use_data = "blup",
  pcov = NULL,
  gcov = NULL,
  SI = 15,
  weights = NULL
)
}
\arguments{
\item{.data}{The input data. It can be either a two-way table with genotypes
in rows and traits in columns, or an object fitted with the function
\code{\link{gamem}()}. Please, see \strong{Details} for more details.}

\item{use_data}{Define which data to use If \code{.data} is an object of
class \code{gamem}. Defaults to \code{"blup"} (the BLUPs for genotypes).
Use \code{"pheno"} to use phenotypic means instead BLUPs for computing the
index.}

\item{pcov, gcov}{The phenotypic and genotypic variance-covariance matrix,
respectively. Defaults to \code{NULL}. If a two-way table is informed in
\code{.data} these matrices are mandatory.}

\item{SI}{The selection intensity (percentage). Defaults to \code{20}}

\item{weights}{The vector of economic weights. Defaults to a vector of 1s
with the same length of the number of traits.}
}
\value{
An object of class \code{hz} containing:
\itemize{
\item \strong{b}: the vector of index coefficient.
\item \strong{index}: The genetic worth.
\item \strong{sel_dif_trait}: The selection differencial.
\item \strong{sel_gen}: The selected genotypes.
\item \strong{gcov}: The genotypic variance-covariance matrix
\item \strong{pcov}: The phenotypic variance-covariance matrix
}
}
\description{
Computes the Smith (1936) and Hazel (1943) index given economic weights and
phenotypic and genotypic variance-covariance matrices. The Smith-Hazel index
is computed as follows:
\loadmathjax
\mjsdeqn{\bf{b = P^{-1}Aw}}

where \mjseqn{\bf{P}} and \mjseqn{\bf{G}} are phenotypic and genetic
covariance matrices, respectively, and \mjseqn{\bf{b}} and \mjseqn{\bf{w}}
are vectors of index coefficients and economic weightings, respectively.

The genetic worth \mjseqn{I} of an individual
genotype based on traits \emph{x}, \emph{y}, ..., \emph{n}, is calculated as:

\mjsdeqn{I = b_xG_x + b_yG_y + ... + b_nG_n}

where \emph{b} the index coefficient for the traits \emph{x}, \emph{y}, ...,
\emph{n}, respectively, and \emph{G} is the individual genotype BLUPs for the
traits \emph{x}, \emph{y}, ..., \emph{n}, respectively.
}
\details{
When using the phenotypic means in \code{.data}, be sure the genotype's code
are in rownames. If \code{.data} is an object of class \code{gamem} them the
BLUPs for each genotype are used to compute the index. In this case, the
genetic covariance components are estimated by mean cross products.
}
\examples{
\donttest{
vcov <- covcor_design(data_g, GEN, REP, everything())
means <- as.matrix(vcov$means)
pcov <- vcov$phen_cov
gcov <- vcov$geno_cov

index <- Smith_Hazel(means, pcov = pcov, gcov = gcov, weights = rep(1, 15))
}
}
\references{
Smith, H.F. 1936. A discriminant function for plant selection. Ann. Eugen.
7:240-250.
\doi{10.1111/j.1469-1809.1936.tb02143.x}

Hazel, L.N. 1943. The genetic basis for constructing selection indexes.
Genetics 28:476-90.
\href{https://pubmed.ncbi.nlm.nih.gov/17247099/}{PMID:17247099}
}
\seealso{
\code{\link{mtsi}}, \code{\link{mgidi}}, \code{\link{fai_blup}}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
