% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineplots.R
\name{lineplots}
\alias{lineplots}
\alias{plot_lines}
\alias{plot_factlines}
\title{Fast way to create line plots}
\usage{
plot_lines(
  .data,
  x,
  y,
  fit,
  level = 0.95,
  confidence = TRUE,
  xlab = NULL,
  ylab = NULL,
  n.dodge = 1,
  check.overlap = FALSE,
  col = "red",
  alpha = 0.2,
  size.shape = 1.5,
  size.line = 1,
  size.text = 12,
  fontfam = "sans",
  plot_theme = theme_metan()
)

plot_factlines(
  .data,
  x,
  y,
  group,
  fit,
  level = 0.95,
  confidence = TRUE,
  xlab = NULL,
  ylab = NULL,
  n.dodge = 1,
  check.overlap = FALSE,
  legend.position = "bottom",
  grid = FALSE,
  scales = "free",
  col = TRUE,
  alpha = 0.2,
  size.shape = 1.5,
  size.line = 1,
  size.text = 12,
  fontfam = "sans",
  plot_theme = theme_metan()
)
}
\arguments{
\item{.data}{The data set}

\item{x, y}{The variables to be mapped to the \code{x} and \code{y} axes,
respectively.}

\item{fit}{The polynomial degree to use. It must be between 1 (linear fit) to
4 (fourth-order polynomial regression.). In \code{plot_factlines()}, if
\code{fit} is a lenth 1 vector, i.e., 1, the fitted curves of all levels in
\code{group} will be fitted with polynomial degree \code{fit}. To use a
different polynomial degree for each level in \code{group}, use a numeric
vector with the same length of the variable in \code{group}.}

\item{level}{The fonfidence level. Defaults to \code{0.05}.}

\item{confidence}{Display confidence interval around smooth? (TRUE by
default)}

\item{xlab, ylab}{The labels of the axes x and y, respectively. Defaults to
\code{NULL}.}

\item{n.dodge}{The number of rows that should be used to render the x labels.
This is useful for displaying labels that would otherwise overlap.}

\item{check.overlap}{Silently remove overlapping labels, (recursively)
prioritizing the first, last, and middle labels.}

\item{col}{The colour to be used in the line plot and points.}

\item{alpha}{The alpha for the color in confidence band}

\item{size.shape}{The size for the shape in plot}

\item{size.line}{The size for the line in the plot}

\item{size.text}{The size of the text}

\item{fontfam}{The family of the font text.}

\item{plot_theme}{The graphical theme of the plot. Default is
\code{plot_theme = theme_metan()}. For more details, see
\code{\link[ggplot2]{theme}}.}

\item{group}{The grouping variable. Valid for \code{plot_factlines()} only.}

\item{legend.position}{Valid argument for \code{plot_factlines}. The position
of the legend. Defaults to 'bottom'.}

\item{grid}{Valid argument for \code{plot_factlines}. Logical argument. If
\code{TRUE} then a grid will be created.}

\item{scales}{Valid argument for \code{plot_factlines}. If \code{grid = TRUE}
scales controls how the scales are in the plot. Possible values are
\code{'free'} (default), \code{'fixed'}, \code{'free_x'} or
\code{'free_y'}.}
}
\value{
An object of class \code{gg, ggplot}.
}
\description{
\itemize{
\item \code{plot_lines()} Creates a line plot based on one quantitative factor
and one numeric variable.  It can be used to show the results of a one-way
trial with \strong{quantitative treatments}.
\item \code{plot_factlines()} Creates a line plot based on: one categorical and one quantitative factor and
one numeric variable.  It can be used to show the results of a
two-way trial with \strong{qualitative-quantitative treatment structure}.
}
}
\examples{
\donttest{
library(metan)
# One-way line plot
df1 <- data.frame(group = "A",
                  x = c(0, 100, 200, 300, 400),
                  y = c(3.2, 3.3, 4.0, 3.8, 3.4))
plot_lines(df1, x, y, fit = 2)

# Two-way line plot
df2 <- data.frame(group = "B",
                  x = c(0, 100, 200, 300, 400),
                  y = c(3.2, 3.3, 3.7, 3.9, 4.1))
facts <- rbind(df1, df2)

p1 <- plot_factlines(facts, x, y, group = group, fit = 1)
p2 <- plot_factlines(facts,
                     x = x,
                     y = y,
                     group = group,
                     fit = c(2, 1),
                     confidence = FALSE)
arrange_ggplot(p1, p2)
}
}
\seealso{
\code{\link{plot_bars}} and \code{\link{plot_factbars}}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
