% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covcor_design.R
\name{covcor_design}
\alias{covcor_design}
\title{Variance-covariance matrices for designed experiments}
\usage{
covcor_design(.data, gen, rep, resp, design = "RCBD", by = NULL, type = NULL)
}
\arguments{
\item{.data}{The data to be analyzed. It can be a data frame, possible with
grouped data passed from \code{\link[dplyr:group_by]{dplyr::group_by()}}.}

\item{gen}{The name of the column that contains the levels of the genotypes.}

\item{rep}{The name of the column that contains the levels of the
replications/blocks.}

\item{resp}{The response variables. For example \code{resp = c(var1, var2, var3)}.}

\item{design}{The experimental design. Must be RCBD or CRD.}

\item{by}{One variable (factor) to compute the function by. It is a shortcut
to \code{\link[dplyr:group_by]{dplyr::group_by()}}. To compute the statistics by more than
one grouping variable use that function.}

\item{type}{What the matrices should return? Set to \code{NULL}, i.e., a list
of matrices is returned. The argument type allow the following values
\verb{'pcor', 'gcor', 'rcor'}, (which will return the phenotypic, genotypic
and residual correlation matrices, respectively) or \verb{'pcov', 'gcov', 'rcov'} (which will return the phenotypic, genotypic and residual
variance-covariance matrices, respectively). Alternatively, it is possible
to get a matrix with the means of each genotype in each trait, by using
\code{type = 'means'}.}
}
\value{
An object of class \code{covcor_design} containing the following
items:
\itemize{
\item \strong{geno_cov} The genotypic covariance.
\item \strong{phen_cov} The phenotypic covariance.
\item \strong{resi_cov} The residual covariance.
\item \strong{geno_cor} The phenotypic correlation.
\item \strong{phen_cor} The phenotypic correlation.
\item \strong{resi_cor} The residual correlation.
}

If \code{.data} is a grouped data passed from \code{\link[dplyr:group_by]{dplyr::group_by()}}
then the results will be returned into a list-column of data frames.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Compute variance-covariance and correlation matrices using data from a
designed (RCBD or CRD) experiment.
}
\examples{
\donttest{
library(metan)
# List of matrices
data <- subset(data_ge2, ENV == 'A1')
matrices <- covcor_design(data,
                          gen = GEN,
                          rep = REP,
                          resp = c(PH, EH, NKE, TKW))

# Genetic correlations
gcor <- covcor_design(data,
                      gen = GEN,
                      rep = REP,
                      resp = c(PH, EH, NKE, TKW),
                      type = 'gcor')

# Residual (co)variance matrix for each environment
rcov <- covcor_design(data_ge2,
                      gen = GEN,
                      rep = REP,
                      resp = c(PH, EH, CD, CL),
                      by = ENV,
                      type = "rcov")
}

}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
