% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arrange_ggplot.R
\name{arrange_ggplot}
\alias{arrange_ggplot}
\title{Arrange separate ggplots into the same graphic}
\usage{
arrange_ggplot(
  ...,
  nrow = NULL,
  ncol = NULL,
  widths = NULL,
  heights = NULL,
  guides = NULL,
  design = NULL,
  legend.position = "bottom",
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  tag_levels = NULL,
  tag_prefix = NULL,
  tag_suffix = NULL,
  tag_sep = NULL,
  theme = NULL
)
}
\arguments{
\item{...}{multiple \code{ggplot}s or a list containing \code{ggplot}
objects.}

\item{nrow, ncol}{The number of rows and columns, respectively.}

\item{widths, heights}{The relative widths and heights of each column and row
in the grid. Will get repeated to match the dimensions of the grid.}

\item{guides}{A string specifying how guides should be treated in the layout.
Defaults to \code{'auto'}. Other possible values are \code{'keep'} and \code{'collect'}.
In this case, will collect guides below to the given nesting level,
removing duplicates.}

\item{design}{Specification of the location of areas in the layout.}

\item{legend.position}{The position of the legends in the plot if
\code{guides = "collect"} Default to \code{'bottom'}.}

\item{title, subtitle, caption}{Text strings to use for the various plot
annotations.}

\item{tag_levels}{A character vector defining the enumeration format to use
at each level. Possible values are \code{'a'} for lowercase letters, \code{'A'} for
uppercase letters, \code{'1'} for numbers, \code{'i'} for lowercase Roman numerals, and
\code{'I'} for uppercase Roman numerals. It can also be a list containing
character vectors defining arbitrary tag sequences. If any element in the
list is a scalar and one of \code{'a'}, \code{'A'}, \code{'1'}, \verb{'i}, or \code{'I'}, this level
will be expanded to the expected sequence.}

\item{tag_prefix, tag_suffix}{Strings that should appear before or after the
tag.}

\item{tag_sep}{A separator between different tag levels.}

\item{theme}{A ggplot theme specification to use for the plot. Only elements
related to the titles as well as plot margin and background is used.}
}
\value{
A \code{patchwork} object
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This is a wraper function around \code{\link[patchwork:wrap_plots]{patchwork::wrap_plots()}} and
\code{\link[patchwork:plot_annotation]{patchwork::plot_annotation()}} to arrange ggplot2 objects.
}
\examples{
\donttest{
library(ggplot2)
library(metan)
p1 <- ggplot(mtcars, aes(wt, mpg)) +
      geom_point()

p2 <- ggplot(mpg, aes(class, hwy)) +
             geom_boxplot()

# Default plot
arrange_ggplot(p1, p2)

# Insert plot annotation, titles and subtitles
arrange_ggplot(p1, p2,
               ncol = 1,
               tag_levels = list(c("(P1)", "(P2)")),
               title = "My grouped ggplot",
               subtitle = "Made with arrange_ggplot()",
               caption = "P1 = scatter plot\nP2 = boxplot",
               theme = theme(plot.title = element_text(size = 20,
                                                       face = "bold"),
                             plot.subtitle = element_text(size = 10,
                                                          face = "italic"),
                             plot.caption  = element_text(size = 10,
                                                          face = "italic")))
}

}
