% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mgidi.R
\name{plot.mgidi}
\alias{plot.mgidi}
\title{Plot the multi-trait genotype-ideotype distance index}
\usage{
\method{plot}{mgidi}(
  x,
  SI = 15,
  radar = TRUE,
  arrange.label = FALSE,
  size.point = 2.5,
  col.sel = "red",
  col.nonsel = "black",
  size.text = 10,
  ...
)
}
\arguments{
\item{x}{An object of class \code{mgidi}}

\item{SI}{An integer [0-100]. The selection intensity in percentage of the
total number of genotypes.}

\item{radar}{Logical argument. If true (default) a radar plot is generated
after using \code{coord_polar()}.}

\item{arrange.label}{Logical argument. If \code{TRUE}, the labels are
arranged to avoid text overlapping. This becomes useful when the number of
genotypes is large, say, more than 30.}

\item{size.point}{The size of the point in graphic. Defaults to 2.5.}

\item{col.sel}{The colour for selected genotypes.}

\item{col.nonsel}{The colour for nonselected genotypes.}

\item{size.text}{The size for the text in the plot. Defaults to 10.}

\item{...}{Other arguments to be passed from ggplot2::theme().}
}
\value{
An object of class \code{gg, ggplot}.
}
\description{
Makes a radar plot showing the multi-trait genotype-ideotype distance index
}
\examples{
\donttest{
library(metan)
model <- gamem(data_g,
               gen = GEN,
               rep = REP,
               resp = c(KW, NR, NKE, NKR))
mgidi_index <- mgidi(model)
plot(mgidi_index)
}


}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
