% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlay.R
\name{overlay.folded}
\alias{overlay.folded}
\title{Create an Overlay Plot for Folded}
\usage{
\method{overlay}{folded}(x, ..., ncol = 4, nrow = 4, color = "black",
  points = TRUE, line = "solid", ylab = NULL, xlab = NULL,
  ylog = FALSE, xlog = FALSE)
}
\arguments{
\item{x}{folded. See \code{\link[fold]{fold}}.}

\item{...}{unquoted names of items to plot}

\item{ncol}{number of panel columns if only one conditioning variable}

\item{nrow}{number of panel rows if only one conditioning variable}

\item{color}{color for points and lines, recycled as necessary}

\item{points}{logical: whether to plot points, recycled as necessary}

\item{line}{character: line types ('none','solid','dashed', etc.  See \code{\link[ggplot2]{geom_line}}). Recycled as necessary}

\item{ylab}{y axis label to override default}

\item{xlab}{x axis label to override default}

\item{ylog}{whether to log-transform y axis data}

\item{xlog}{whether to log-transform x axis data}
}
\value{
a list of ggplot, possibly length one
}
\description{
Creates an overlay plot for class 'folded'.  Continuous items are plotted vs last continuous item, conditioned (facetted) by up to two categorical items.
}
\seealso{
\code{\link{overlay.data.frame}}

Other multivariate plots: \code{\link{corsplom}},
  \code{\link{metaplot}}, \code{\link{overlay.data.frame}}
}
