% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatter.R
\name{scatter_data_frame}
\alias{scatter_data_frame}
\title{Scatterplot Function for Data Frame}
\usage{
scatter_data_frame(x, yvar, xvar, groups = NULL, facets = NULL,
  ylog = log, xlog = log, yref = NULL, xref = NULL, ylab = NULL,
  xlab = NULL, ysmooth = FALSE, xsmooth = FALSE, cols = NULL,
  density = FALSE, iso = FALSE, main = FALSE, corr = FALSE,
  crit = 1.3, na.rm = TRUE, fit = conf, conf = FALSE, loc = 0,
  aspect = 1, auto.key = NULL, as.table = TRUE, log = FALSE,
  msg = "metastats", panel = metapanel, ...)
}
\arguments{
\item{x}{data.frame}

\item{yvar}{character: y variable(s)}

\item{xvar}{character: x variable}

\item{groups}{optional grouping item; ignored if more than one \code{yvar}}

\item{facets}{character: up to two grouping items}

\item{ylog}{log transform y axis (guessed if NULL)}

\item{xlog}{log transform x axis (guessed if NULL)}

\item{yref}{reference line from y axis}

\item{xref}{reference line from x axis}

\item{ylab}{y axis label, constructed from attributes \code{label} and \code{guide} if available}

\item{xlab}{x axis label, constructed from attributes \code{label} and \code{guide} if available}

\item{ysmooth}{supply loess smooth of y on x}

\item{xsmooth}{supply loess smmoth of x on y}

\item{cols}{suggested columns for auto.key}

\item{density}{plot point density instead of points (ignored if \code{groups} is supplied)}

\item{iso}{use isometric axes with line of unity}

\item{main}{logical: whether to construct a default title; or a substitute title or NULL}

\item{corr}{append Pearson correlation coefficient to default title (only if main is \code{TRUE})}

\item{crit}{if ylog or xlog missing, log transform if mean/median ratio for non-missing values is greater than crit}

\item{na.rm}{whether to remove data points with one or more missing coordinates}

\item{fit}{draw a linear fit of y ~ x}

\item{conf}{logical, or width for a confidence region around a linear fit; passed to \code{\link{region}}; \code{TRUE} defaults to 95 percent confidence interval}

\item{loc}{where to print statistics on a panel}

\item{aspect}{tpassed to \code{\link[lattice]{xyplot}}}

\item{auto.key}{passed to \code{\link[lattice]{xyplot}}}

\item{as.table}{passed to \code{\link[lattice]{xyplot}}}

\item{log}{a default sharede by \code{ylog} and \code{xlog}}

\item{msg}{a function to print text on a panel: called with x values, y values, and \dots.}

\item{panel}{name or definition of panel function}

\item{...}{passed to \code{\link{region}}}
}
\description{
Scatterplot function for class 'data.frame'. Uses standard evaluation.
}
\examples{
library(magrittr)
library(dplyr)
attr(Theoph$conc,'label') <- 'theophylline concentration'
attr(Theoph$conc,'guide') <- 'mg/L'
attr(Theoph$Time,'label') <- 'time'
attr(Theoph$Time,'guide') <- 'h'
attr(Theoph$Subject,'guide') <- '////'
scatter_data_frame(Theoph, 'conc', 'Time')
scatter_data_frame(Theoph, 'conc','Time', 'Subject')
scatter_data_frame(Theoph, 'conc','Time', facets = 'Subject')
scatter_data_frame(Theoph \%>\% filter(conc > 0), 'conc','Time', 'Subject',ylog = TRUE, yref = 5)
scatter_data_frame(Theoph, 'conc','Time', 'Subject',ysmooth = TRUE)
scatter_data_frame(Theoph, 'conc','Time', main = TRUE, corr = TRUE)
scatter_data_frame(Theoph, 'conc','Time', conf = TRUE, loc = 3, yref = 6)
}
\seealso{
\code{\link{metapanel}}

Other bivariate plots: \code{\link{boxplot.folded}},
  \code{\link{metaplot.data.frame}},
  \code{\link{metaplot.folded}},
  \code{\link{scatter.data.frame}},
  \code{\link{scatter.folded}}

Other scatter: \code{\link{scatter.data.frame}},
  \code{\link{scatter.folded}}
}
