% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{abcd_pubertal}
\alias{abcd_pubertal}
\title{Mock ABCD pubertal status data}
\format{
\subsection{\code{abcd_pubertal}}{

A data frame with 275 rows and 2 columns:
\describe{
\item{patient}{The unique identifier of the ABCD dataset}
\item{pubertal_status}{Average reported pubertal status between child and parent (1-5 categorical scale)}
}
}
}
\source{
Though this data is no longer "real" ABCD data, the reference for using ABCD as a data source is below:

Data used in the preparation of this article were obtained from the Adolescent Brain Cognitive DevelopmentSM (ABCD) Study (https://abcdstudy.org), held in the NIMH Data Archive (NDA). This is a multisite, longitudinal study designed to recruit more than 10,000 children age 9-10 and follow them over 10 years into early adulthood. The ABCD Study® is supported by the National Institutes of Health and additional federal partners under award numbers U01DA041048, U01DA050989, U01DA051016, U01DA041022, U01DA051018, U01DA051037, U01DA050987, U01DA041174, U01DA041106, U01DA041117, U01DA041028, U01DA041134, U01DA050988, U01DA051039, U01DA041156, U01DA041025, U01DA041120, U01DA051038, U01DA041148, U01DA041093, U01DA041089, U24DA041123, U24DA041147. A full list of supporters is available at https://abcdstudy.org/federal-partners.html. A listing of participating sites and a complete listing of the study investigators can be found at https://abcdstudy.org/consortium_members/. ABCD consortium investigators designed and implemented the study and/or provided data but did not necessarily participate in the analysis or writing of this report. This manuscript reflects the views of the authors and may not reflect the opinions or views of the NIH or ABCD consortium investigators.
}
\usage{
abcd_pubertal
}
\description{
A randomly shuffled and anonymized copy of pubertal status data from the NIMH Data
archive. The original files used were abcd_ssphp01.txt and abcd_ssphy01.txt. The file was pre-processed
by the abcdutils package (https://github.com/BRANCHlab/abcdutils) function
\code{get_pubertal_status}.
}
\keyword{datasets}
