% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{df.radua2019}
\alias{df.radua2019}
\title{Meta-analyses exploring the risk factors for posttraumatic stress disorder.}
\format{
The dataset contains the following variables: \tabular{ll}{
  \strong{meta_review} \tab name of the first author of the meta-analysis.\cr
  \tab \cr
  \strong{factor} \tab name of the risk factor.\cr
  \tab \cr
  \strong{author} \tab first study author of the individual studies.\cr
  \tab \cr
  \strong{year} \tab year of publication of the individual studies.\cr
  \tab \cr
  \strong{multiple_es} \tab indicates the reason of the presence of multiple effect sizes \cr
  \tab (due to multiple groups or outcomes) per study.\cr
  \tab \cr
  \strong{measure} \tab type of effect size.\cr
  \tab \cr
  \strong{value} \tab value of the effect size.\cr
  \tab \cr
  \strong{ci_lo} \tab lower bound of the 95\% confidence interval.\cr
  \tab \cr
  \strong{ci_up} \tab upper bound of the 95\% confidence interval.\cr
  \tab \cr
  \strong{n_cases} \tab number of cases.\cr
  \tab \cr
  \strong{n_controls} \tab number of controls.\cr
  \tab \cr
  \strong{n_exp} \tab number of participants in the exposed group (sum of the number of cases\cr
  \tab and controls in the exposed group).\cr
  \tab \cr
  \strong{n_nexp} \tab number of participants in the non-exposed group (sum of the number of cases\cr
  \tab and controls in the non-exposed group).\cr
  \tab \cr
  \strong{n_cases_exp} \tab number of cases in the exposed group.\cr
  \tab \cr
  \strong{n_controls_exp} \tab number of controls in the exposed group.\cr
  \tab \cr
  \strong{n_cases_nexp} \tab number of cases in the non-exposed group.\cr
  \tab \cr
  \strong{n_controls_nexp} \tab number of controls in the non-exposed group.\cr
  \tab \cr
  \strong{mean_cases} \tab means of participants in the experimental arm.\cr
  \tab \cr
  \strong{sd_cases} \tab standard deviation of participants in the experimental arm.\cr
  \tab \cr
  \strong{mean_controls} \tab means of participants in the control arm.\cr
  \tab \cr
  \strong{sd_controls} \tab standard deviation of participants in the control arm.\cr
  \tab \cr
  \strong{amstar} \tab AMSTAR score of the meta-analysis\cr
  }
}
\source{
Tortella-Feliu, M. and Fullana, M.A., Perez-Vigil, A., Torres, X., Chamorro, J., and Littarelli, S.A., ..., & Radua, J. (2019). Risk Factors for Posttraumatic Stress Disorder: An Umbrella Review of Systematic Reviews and Meta-Analyses.
\emph{Neuroscience & Biobehavioral Reviews}, \bold{107}, 154--165.
}
\usage{
df.radua2019
}
\description{
Real dataset taken from Tortella-Feliu et al. (2019).
}
\keyword{datasets}
