% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpatialGridMeteorology-methods.R
\name{spplot,SpatialGridMeteorology-method}
\alias{spplot,SpatialGridMeteorology-method}
\alias{spplot,SpatialGridTopography-method}
\alias{spplot,SpatialPixelsTopography-method}
\alias{spplot,SpatialPixelsMeteorology-method}
\title{Spatial grid plots}
\usage{
\S4method{spplot}{SpatialGridMeteorology}(obj, date, variable = "MeanTemperature", ...)
}
\arguments{
\item{obj}{An object of class \code{SpatialGridTopography}.}

\item{date}{A string or an integer for the date to be plotted.}

\item{variable}{A string of the variable to be plotted (only
\code{type="elevation"}, \code{type="slope"}, \code{type="aspect"} are
allowed).}

\item{...}{Additional parameters to function \code{\link{spplot}}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Function \code{spplot} for \code{\link{SpatialGridTopography-class}} and
\code{\link{SpatialPixelsTopography-class}} objects allows drawing maps of
topographic attributes. Function \code{spplot} for
\code{\link{SpatialGridMeteorology-class}} and
\code{\link{SpatialPixelsMeteorology-class}} objects allows drawing maps of
meteorological variables corresponding to specific dates.
}
\examples{

data(examplegridtopography)

#Display data
spplot(examplegridtopography, type="elevation", scales=list(draw=TRUE))
spplot(examplegridtopography, type="slope", scales=list(draw=TRUE))
spplot(examplegridtopography, type="aspect", scales=list(draw=TRUE))

}
\seealso{
\code{\link{meteoplot}}
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF
}
