% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google-forms.R
\name{get_google_form}
\alias{get_google_form}
\title{Get Google Forms}
\usage{
get_google_form(form_id, token = NULL, dataformat = "dataframe")
}
\arguments{
\item{form_id}{The form ID we need to get}

\item{token}{credentials for access to Google using OAuth. `authorize("google")`}

\item{dataformat}{What format would you like the data? Options are "raw" or "dataframe". "dataframe" is the default.}
}
\value{
This returns a list of the form info and responses to the google form. Default is to make this a list of nicely formatted dataframes.
}
\description{
This is a function to get Google Form info and responses from the API
}
\examples{
\dontrun{

authorize("google")
form_info <- get_google_form(
  "https://docs.google.com/forms/d/1Neyj7wwNpn8wC7NzQND8kQ30cnbbETSpT0lKhX7uaQY/edit"
)
form_id <- "https://docs.google.com/forms/d/1Neyj7wwNpn8wC7NzQND8kQ30cnbbETSpT0lKhX7uaQY/edit"

### OR You can give it a direct form id

form_info <- get_google_form("1Neyj7wwNpn8wC7NzQND8kQ30cnbbETSpT0lKhX7uaQY")
}
}
