% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NCdiag.R
\name{NC.diag}
\alias{NC.diag}
\title{Score and likelihood ratio tests fit of equality of shape over multiple thresholds}
\usage{
NC.diag(
  xdat,
  u,
  GP.fit = c("Grimshaw", "nlm", "optim", "ismev"),
  do.LRT = FALSE,
  size = NULL,
  plot = TRUE,
  ...,
  xi.tol = 0.001
)
}
\arguments{
\item{xdat}{numeric vector of raw data}

\item{u}{\code{m}-vector of thresholds (sorted from smallest to largest)}

\item{GP.fit}{function used to optimize the generalized Pareto model.}

\item{do.LRT}{boolean indicating whether to perform the likelihood ratio test (in addition to the score test)}

\item{size}{level at which a horizontal line is drawn on multiple threshold plot}

\item{plot}{logical; if \code{TRUE}, return a plot of p-values against threshold.}

\item{...}{additional parameters passed to \code{plot}}

\item{xi.tol}{numerical tolerance for threshold distance; if the absolute value of \code{xi1.hat} is less than \code{xi.tol} use linear interpolation
to evaluate score vectors, expected Fisher information matrices, Hessians}
}
\value{
a plot of P-values for the test at the different thresholds \code{u}
}
\description{
The function returns a P-value path for the score testand/or likelihood ratio
test for equality of the shape parameters over
multiple thresholds under the generalized Pareto model.
}
\details{
The default method is \code{'Grimshaw'} using the reduction of the parameters to a one-dimensional
maximization. Other options are one-dimensional maximization of the profile the \code{nlm} function or \code{optim}.
Two-dimensional optimisation using 2D-optimization \code{\link[ismev]{ismev}} using the routine
from \code{gpd.fit} from the \code{ismev} library, with the addition of the algebraic gradient.
The choice of \code{GP.fit} should make no difference but the options were kept.
\bold{Warning}: the function will not recover from failure of the maximization routine, returning various error messages.
}
\examples{
\dontrun{
data(nidd)
u <- seq(65,90, by = 1L)
NC.diag(nidd, u, size = 0.05)
}
}
\references{
Grimshaw (1993). Computing Maximum Likelihood Estimates for the Generalized
 Pareto Distribution, \emph{Technometrics}, \bold{35}(2), 185--191.

Northrop & Coleman (2014). Improved threshold diagnostic plots for extreme value
analyses, \emph{Extremes}, \bold{17}(2), 289--303.

Wadsworth & Tawn (2012). Likelihood-based procedures for threshold
diagnostics and uncertainty in extreme value modelling, \emph{J. R. Statist. Soc. B}, \bold{74}(3), 543--567.
}
\author{
Paul J. Northrop and Claire L. Coleman
}
