% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univdist.R
\name{gevN}
\alias{gevN}
\title{Generalized extreme value distribution (quantile/mean of N-block maxima parametrization)}
\arguments{
\item{par}{vector of \code{loc}, quantile/mean of N-block maximum and \code{shape}}

\item{dat}{sample vector}

\item{V}{vector calculated by \code{gevN.Vfun}}

\item{q}{probability, corresponding to \eqn{q}th quantile of the \code{N}-block maximum}

\item{qty}{string indicating whether to calculate the \code{q} quantile or the mean}
}
\description{
Likelihood, score function and information matrix,
approximate ancillary statistics and sample space derivative
for the generalized extreme value distribution  parametrized in terms of the
quantiles/mean of N-block maxima parametrization \eqn{z}, scale and shape.
}
\section{Usage}{
 \preformatted{gevN.ll(par, dat, N, q, qty = c('mean', 'quantile'))
gevN.ll.optim(par, dat, N, q = 0.5, qty = c('mean', 'quantile'))
gevN.score(par, dat, N, q = 0.5, qty = c('mean', 'quantile'))
gevN.infomat(par, dat, qty = c('mean', 'quantile'), method = c('obs', 'exp'), N, q = 0.5, nobs = length(dat))
gevN.Vfun(par, dat, N, q = 0.5, qty = c('mean', 'quantile'))
gevN.phi(par, dat, N, q = 0.5, qty = c('mean', 'quantile'), V)
gevN.dphi(par, dat, N, q = 0.5, qty = c('mean', 'quantile'), V)}
}

\section{Functions}{

\itemize{
\item \code{gevN.ll}: log likelihood
\item \code{gevN.score}: score vector
\item \code{gevN.infomat}: expected and observed information matrix
\item \code{gevN.Vfun}: vector implementing conditioning on approximate ancillary statistics for the TEM
\item \code{gevN.phi}: canonical parameter in the local exponential family approximation
\item \code{gevN.dphi}: derivative matrix of the canonical parameter in the local exponential family approximation
}
}

\author{
Leo Belzile
}
