% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profile.R
\name{tem.corr}
\alias{tem.corr}
\title{Bridging the singularity for higher order asymptotics}
\usage{
tem.corr(fr, print.warning = FALSE)
}
\arguments{
\item{fr}{an object of class \code{fr}}

\item{print.warning}{logical; should warning message be printed? Default to \code{FALSE}}
}
\value{
an object of class \code{fr}, containing as additional arguments \code{spline} and a modified \code{rstar} argument.
}
\description{
The correction factor \eqn{\log(q/r)/r} for the
likelihood root is unbounded in the vincinity of
the maximum likelihood estimator. The thesis of
Rongcai Li (University of Toronto, 2001)
explores different ways of bridging this
singularity, notably using asymptotic expansions.
}
\details{
The poor man's method used here consists in
fitting a robust regression to \eqn{1/q-1/r}
as a function of \eqn{r} and using predictions
from the model to solve for \eqn{q}. This
approach is seemingly superior to that
previously used in \link{spline.corr}.
}
\keyword{internal}
