% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.mfp2.R
\name{predict.mfp2}
\alias{predict.mfp2}
\title{Predict Method for \code{mfp2} Fits}
\usage{
\method{predict}{mfp2}(
  object,
  newdata = NULL,
  type = NULL,
  terms = NULL,
  terms_seq = c("equidistant", "data"),
  alpha = 0.05,
  ref = NULL,
  strata = NULL,
  newoffset = NULL,
  ...
)
}
\arguments{
\item{object}{a fitted object of class \code{mfp2}.}

\item{newdata}{optionally, a matrix with column names in which to look for
variables with which to predict. See \code{\link[=mfp2]{mfp2()}} for details.}

\item{type}{the type of prediction required.  The default is on the
scale of the linear predictors. See \code{predict.glm()} or \code{predict.coxph()} for
details. In case \code{type = "terms"}, see the Section on \verb{Terms prediction}.
In case \code{type = "contrasts"}, see the Section on \code{Contrasts}.}

\item{terms}{a character vector of variable names specifying for which
variables term or contrast predictions are desired.
Only used in case \code{type = "terms"} or \code{type = "contrasts"}.
If \code{NULL} (the default) then all selected variables in the final model will
be used. In any case, only variables used in the final model are used, even
if more variable names are passed.}

\item{terms_seq}{a character string specifying how the range of variable
values for term predictions are handled. The default \code{equidistant} computes
the range of the data range and generates an equidistant sequence of
100 points from the minimum to the maximum values to properly show the functional
form estimated in the final model.
The option \code{data} uses the observed data values directly, but these may not
adequately reflect the functional form of the data, especially when extreme
values or influential points are present.}

\item{alpha}{significance level used for computing confidence
intervals in terms prediction.}

\item{ref}{a named list of reference values used when \code{type = "contrasts"}.
Note that any variable requested in \code{terms}, but not having an entry in this
list (or if the entry is \code{NULL}) then the mean value (or minimum for binary
variables) will be used as reference. Values are specified on the original
scale of the variable since the program will internally scale it using the
scaling factors obtained from \code{\link[=find_scale_factor]{find_scale_factor()}}. By default, this function
uses the means (for continuous variables) and minima (for binary variables) as
reference values.}

\item{strata}{stratum levels used for predictions.}

\item{newoffset}{A vector of offsets used for predictions. This parameter is important when
newdata is supplied. The offsets will be directly added to the linear predictor without any
transformations.}

\item{...}{further arguments passed to \code{predict.glm()} or \code{predict.coxph()}.}
}
\value{
For any \code{type} other than \code{"terms"} the output conforms to the output
of \code{predict.glm()} or \code{predict.coxph()}.

If \code{type = "terms"} or \code{type = "contrasts"}, then a named list with entries
for each variable requested in \code{terms} (excluding those not present in the
final model).
Each entry is a \code{data.frame} with the following columns:
\itemize{
\item \code{variable}: variable values on original scale.
\item \code{variable_pre}: variable with pre-transformation applied, i.e. shifted,
scaled and centered as required.
\item \code{value}: partial linear predictor or contrast (depending on \code{type}).
\item \code{se}: standard error of partial linear predictor or contrast.
\item \code{lower}: lower limit of confidence interval.
\item \code{upper}: upper limit of confidence interval.
}
}
\description{
Obtains predictions from an \code{mfp2} object.
}
\details{
To prepare the \code{newdata} for prediction, this function applies any
necessary shifting and scaling based on the factors obtained from the
training data.
It is important to note that if the shifting factors are not sufficiently
large as estimated from the training data, variables in \code{newdata} may end up
with negative values, which can cause prediction errors if non-linear
functional forms are used. A warning is given in this case by the function.
The next step involves transforming the data using the selected
fractional polynomial (FP) powers. If necessary, centering of variables is
conducted. Once the transformation (and centering) is complete, the
transformed data is passed to either \code{predict.glm()} or \code{predict.coxph()},
depending on the chosen family of models and when type is not
\code{terms} and \code{contrasts}.
}
\section{Terms prediction}{

This function allows to compute the partial linear predictors
for each variable selected into the final model if \code{type = "terms"}. Note
that the results returned from this function are different from those of
\code{predict.glm()} and \code{predict.coxph()} since these functions do not take
into account that a single variable can be represented by multiple terms.
This functionality is useful to assess model fit, since it also allows to
draw data points based on residuals.
}

\section{Contrasts}{

This functions allows to compute contrasts with reference to a specified
variable value if \code{type = "contrasts"}. In this case, the fitted partial
predictors will be centered at the reference value (i.e. 0), and also
confidence intervals will have width 0 at that point.
}

\examples{

# Gaussian model
data("prostate")
x = as.matrix(prostate[,2:8])
y = as.numeric(prostate$lpsa)
# default interface
fit1 = mfp2(x, y, verbose = FALSE)
predict(fit1) # make predictions

}
\seealso{
\code{\link[=mfp2]{mfp2()}}, \code{\link[stats:predict.glm]{stats::predict.glm()}}, \code{\link[survival:predict.coxph]{survival::predict.coxph()}}
}
