% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addEnst_function.R
\name{addEnst}
\alias{addEnst}
\title{Add transcript information to list}
\usage{
addEnst(mgl)
}
\arguments{
\item{mgl}{List; see \code{\link{buildFromNames}}, \code{\link{buildFromRegion}}, or \code{\link{buildFromEnsgs}}}
}
\description{
\code{addEnst} returns an 'mgl' list with the second element containing information about the trascripts for the gene of interest including external transcript name, ensembl transcript name, and biotype (an Ensembl defined classification of transcript type: e.g. non-coding, protein coding; see \url{http://www.ensembl.org/Help/Faq?id=468})
}
\examples{
\dontrun{buildFromRegion(chr = 2, start = 102314000, stop = 103435000) -> myMgl}
\dontrun{myMgl <- addEnst(myMgl)}

}
\seealso{
Other elements: \code{\link{addAei}},
  \code{\link{addAntisense}}, \code{\link{addCisEqtl}},
  \code{\link{addDnase}}, \code{\link{addExpression}},
  \code{\link{addGo}}, \code{\link{addGrasp}},
  \code{\link{addGwasCatalog}}, \code{\link{addLoc}},
  \code{\link{addPtv}}, \code{\link{addPubmed}},
  \code{\link{addSqtlAltrans}}, \code{\link{addSqtlSeek}},
  \code{\link{addTransEqtl}}, \code{\link{missNames}}
}

