% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mipo.R
\name{mipo}
\alias{mipo}
\alias{mipo}
\alias{summary.mipo}
\alias{print.mipo}
\alias{print.mipo.summary}
\alias{process_mipo}
\title{\code{mipo}: Multiple imputation pooled object}
\usage{
mipo(mira.obj, ...)

\method{summary}{mipo}(object, type = c("tests", "all"), conf.int = FALSE,
  conf.level = 0.95, exponentiate = FALSE, ...)

\method{print}{mipo}(x, ...)

\method{print}{mipo.summary}(x, ...)

process_mipo(z, x, conf.int = FALSE, conf.level = 0.95,
  exponentiate = FALSE)
}
\arguments{
\item{mira.obj}{An object of class \code{mira}}

\item{\dots}{Arguments passed down}

\item{object}{An object of class \code{mipo}}

\item{conf.int}{Logical indicating whether to include 
a confidence interval. The default is \code{FALSE}.}

\item{conf.level}{Confidence level of the interval, used only if
\code{conf.int = TRUE}. Number between 0 and 1.}

\item{exponentiate}{Flag indicating whether to exponentiate the 
coefficient estimates and confidence intervals (typical for 
logistic regression).}

\item{x}{An object of class \code{mipo}}

\item{z}{Data frame with a tidied version of a coefficient matrix}
}
\value{
The \code{summary} method returns a data frame with summary statistics of the pooled analysis.
}
\description{
The \code{mipo} object contains the results of the pooling step. 
The function \code{\link{pool}} generates an object of class \code{mipo}.
}
\details{
An object class \code{mipo} is a \code{list} with three 
elements: \code{call}, \code{m} and \code{pooled}.

The \code{pooled} elements is a data frame with columns:
\tabular{ll}{
\code{estimate}\tab Pooled complete data estimate\cr
\code{ubar}    \tab Within-imputation variance of \code{estimate}\cr
\code{b}       \tab Between-imputation variance of \code{estimate}\cr
\code{t}       \tab Total variance, of \code{estimate}\cr
\code{dfcom}   \tab Degrees of freedom in complete data\cr
\code{df}      \tab Degrees of freedom of $t$-statistic\cr
\code{riv}     \tab Relative increase in variance\cr
\code{lambda}  \tab Proportion attributable to the missingness\cr
\code{fmi}     \tab Fraction of missing information\cr
}
The names of the terms are stored as \code{row.names(pooled)}.

The \code{process_mipo} is a helper function to process a 
tidied mipo object, and is normally not called directly.
It adds a confidence interval, and optionally exponentiates, the result.
}
\references{
van Buuren S and Groothuis-Oudshoorn K (2011). \code{mice}:
Multivariate Imputation by Chained Equations in \code{R}. \emph{Journal of
Statistical Software}, \bold{45}(3), 1-67.
\url{http://www.jstatsoft.org/v45/i03/}
}
\seealso{
\code{\link{pool}}, 
\code{\link[=mids-class]{mids}}, \code{\link[=mira-class]{mira}}
}
\keyword{classes}
\keyword{internal}
