% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grpoutputs.R
\name{grpoutputs}
\alias{grpoutputs}
\title{Load and group outputs from files}
\usage{
grpoutputs(outputs, folders, files, lvls = NULL, concat = F,
  centscal = "range", ...)
}
\arguments{
\item{outputs}{A vector with the labels of each output, or an integer with
the number of outputs (in which case output labels will be assigned
automatically). In either case, the number of outputs should account for
an additional concatenated output, as specified in the \code{concat}
parameter.}

\item{folders}{Vector of folder names where to read files from. These are
recycled if \code{length(folders) < length(files)}.}

\item{files}{Vector of filenames or file sets to load in each folder. File
sets can be given as \link[=regex]{regular expressions}, or as wildcards by
wrapping them with \code{\link[utils]{glob2rx}}.}

\item{lvls}{Vector of factor levels (groups). Must be the same length as
\code{files}, i.e. each file set will be associated with a different level or
group. If not given, default group names will be used.}

\item{concat}{If TRUE add an additional output which corresponds to the
concatenation of all outputs, properly centered and scaled.}

\item{centscal}{Method for centering and scaling outputs if \code{concat} is
TRUE. It can be one of "center", "auto", "range" (default), "iqrange",
"vast", "pareto" or "level". Centering and scaling is performed by the
\code{\link{centerscale}} function.}

\item{...}{Options passed to \code{\link[utils]{read.table}}, which is used
to read the files specified in the \code{files} parameter.}
}
\value{
Object of class \code{grpoutputs} containing the following data:
\describe{
 \item{data}{List of all outputs, each one grouped into a \emph{n} x \emph{m}
       matrix, where \emph{n} is the total number of output observations
       and \emph{m} is the number of variables or dimensions (i.e. output
       length).}
 \item{groupsize}{Vector containing number of observations for each level or
       group.}
 \item{obs_lvls}{Factor vector of levels or groups associated with each
       observation.}
 \item{lvls}{Vector of factor levels in the order they occur (as given in
       parameter with the same name).}
 \item{concat}{Boolean indicating if this object was created with an
       additional concatenated output.}
}
}
\description{
Load and group outputs from files containing multiple observations of the
groups to be compared.
}
\details{
Each file corresponds to an observation, and should have a tabular format
where columns correspond to outputs and rows to variables or dimensions.
Observations (files) are grouped by factor levels which correspond to the
file groups given in the \code{files} parameter. Factor levels differentiate
observations from distinct groups.
}
\examples{
# Determine paths for data folders, each containing outputs for 10 runs of
# the PPHPC model
dir_nl_ok <- system.file("extdata", "nl_ok", package = "micompr")
dir_jex_ok <- system.file("extdata", "j_ex_ok", package = "micompr")
files <- glob2rx("stats400v1*.tsv")

# Create a grouped outputs object using outputs from NetLogo and Java
# implementations of the PPHPC model
go <- grpoutputs(7, c(dir_nl_ok, dir_jex_ok), c(files, files),
                 lvls = c("NL", "JEX"), concat = TRUE)

# Do the same, but specify output names and don't specify levels
go <- grpoutputs(c("a", "b", "c", "d", "e", "f"),
                 c(dir_nl_ok, dir_jex_ok), c(files, files))
}

