% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latex_tables.R
\name{tikzscat}
\alias{tikzscat}
\title{Simple \code{TikZ} scatter plot}
\usage{
tikzscat(data, obs_lvls, marks, tscale, axes_color = "gray")
}
\arguments{
\item{data}{Data to plot, \emph{m} x 2 numeric matrix, where \emph{m} is the
number of observations or points to plot.}

\item{obs_lvls}{Levels or groups associated with each observation.}

\item{marks}{Character vector determining how to draw the points in
\code{TikZ}, for example: \code{
c("mark=square*,mark options={color=red},mark size=0.8pt",
  "mark=diamond*,mark options={color=black},mark size=1pt",
  "mark=triangle*,mark options={color=green},mark size=1pt")}.}

\item{tscale}{The \code{scale} property of the \code{TikZ} figure.}

\item{axes_color}{Axes color (must be a \code{LaTeX}/\code{TikZ} color).}
}
\value{
A string containing the \code{TikZ} figure code for plotting the
specified \code{data}.
}
\description{
Create a simple 2D \code{TikZ} scatter plot, useful for plotting PCA data.
}
\details{
This function creates a simple \code{TikZ} 2D scatter plot within a
\code{tikzpicture} environment. The points are plotted on a normalized
figure with \emph{x} and \emph{y} axes bounded between [-1, 1]. To render
adequately, the final \code{LaTeX} document should load the \code{plotmarks}
\code{TikZ} library.
}
\examples{
tikzscat(rbind(c(1.5, 2), c(0.5, 1)), factor(c(1,2)),
         c("mark=square*,mark options={color=red},mark size=0.8pt",
           "mark=diamond*,mark options={color=black},mark size=1pt"),
         6)

}
