% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bclust.R
\name{bClust}
\alias{bClust}
\title{Clustering sequences based on pairwise distances}
\usage{
bClust(dist.tbl, linkage = "complete", threshold = 0.75, verbose = FALSE)
}
\arguments{
\item{dist.tbl}{A \code{tibble} with pairwise distances.}

\item{linkage}{A text indicating what type of clustering to perform, either \samp{complete} (default),
\samp{average} or \samp{single}.}

\item{threshold}{Specifies the maximum size of a cluster. Must be a distance, i.e. a number between
0.0 and 1.0.}

\item{verbose}{Logical, turns on/off text output during computations.}
}
\value{
The function returns a vector of integers, indicating the cluster membership of every unique
sequence from the \samp{Query} or \samp{Hit} columns of the input \samp{dist.tbl}. The name
of each element indicates the sequence. The numerical values have no meaning as such, they are simply
categorical indicators of cluster membership.
}
\description{
Sequences are clustered by hierarchical clustering based on a set of pariwise distances.
The distances must take values between 0.0 and 1.0, and all pairs \emph{not} listed are assumed to
have distance 1.0.
}
\details{
Computing clusters (gene families) is an essential step in many comparative studies.
\code{\link{bClust}} will assign sequences into gene families by a hierarchical clustering approach.
Since the number of sequences may be huge, a full all-against-all distance matrix will be impossible
to handle in memory. However, most sequence pairs will have an \sQuote{infinite} distance between them,
and only the pairs with a finite (smallish) distance need to be considered.

This function takes as input the distances in \code{dist.tbl} where only the relevant distances are
listed. The columns \samp{Query} and \samp{Hit} contain tags identifying pairs of sequences. The column
\samp{Distance} contains the distances, always a number from 0.0 to 1.0. Typically, this is the output
from \code{\link{bDist}}. All pairs of sequences \emph{not} listed are assumed to have distance 1.0,
which is considered the \sQuote{infinite} distance.
All sequences must be listed at least once in ceither column \samp{Query} or \samp{Hit} of the \code{dist.tbl}.
This should pose no problem, since all sequences must have distance 0.0 to themselves, and should be listed
with this distance once (\samp{Query} and \samp{Hit} containing the same tag). 

The \samp{linkage} defines the type of clusters produced. The \samp{threshold} indicates the size of
the clusters. A \samp{single} linkage clustering means all members of a cluster have at least one other
member of the same cluster within distance \samp{threshold} from itself. An \samp{average} linkage means
all members of a cluster are within the distance \samp{threshold} from the center of the cluster. A
\samp{complete} linkage means all members of a cluster are no more than the distance \samp{threshold}
away from any other member of the same cluster. 

Typically, \samp{single} linkage produces big clusters where members may differ a lot, since they are
only required to be close to something, which is close to something,...,which is close to some other
member. On the other extreme, \samp{complete} linkage will produce small and tight clusters, since all
must be similar to all. The \samp{average} linkage is between, but closer to \samp{complete} linkage. If
you want the \samp{threshold} to specify directly the maximum distance tolerated between two members of
the same gene family, you must use \samp{complete} linkage. The \samp{single} linkage is the fastest
alternative to compute. Using the default setting of \samp{single} linkage and maximum \samp{threshold}
(1.0) will produce the largest and fewest clusters possible.
}
\examples{
# Loading example BLAST distances
data(xmpl.bdist)

# Clustering with default settings
clst <- bClust(xmpl.bdist)
# Other settings, and verbose
clst <- bClust(xmpl.bdist, linkage = "average", threshold = 0.5, verbose = TRUE)

}
\seealso{
\code{\link{bDist}}, \code{\link{hclust}}, \code{\link{dClust}}, \code{\link{isOrtholog}}.
}
\author{
Lars Snipen and Kristian Hovde Liland.
}
