% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/external.R
\name{findGenes}
\alias{findGenes}
\title{Finding coding genes}
\usage{
findGenes(
  genome.file,
  faa.file = "",
  ffn.file = "",
  proc = "single",
  trans.tab = 11,
  mask.N = FALSE,
  bypass.SD = FALSE
)
}
\arguments{
\item{genome.file}{A FASTA file with the genome sequence(s).}

\item{faa.file}{If provided, prodigal will output all proteins to this fasta-file (text).}

\item{ffn.file}{If provided, prodigal will output all DNA sequences to this fasta-file (text).}

\item{proc}{Either \code{"single"} or \code{"meta"}, see below.}

\item{trans.tab}{Either 11 or 4 (see below).}

\item{mask.N}{Turn on masking of N's (logical)}

\item{bypass.SD}{Bypass Shine-Dalgarno filter (logical)}
}
\value{
A GFF-table (see \code{\link{readGFF}} for details) with one row for each detected
coding gene.
}
\description{
Finding coding genes in genomic DNA using the Prodigal software.
}
\details{
The external software Prodigal is used to scan through a prokaryotic genome to detect the protein
coding genes. This free software can be installed from https://github.com/hyattpd/Prodigal.

In addition to the standard output from this function, FASTA files with protein and/or DNA sequences may
be produced directly by providing filenames in \code{faa.file} and \code{ffn.file}.

The input \code{proc} allows you to specify if the input data should be treated as a single genome
(default) or as a metagenome.

The translation table is by default 11 (the standard code), but table 4 should be used for Mycoplasma etc.

The \code{mask.N} will prevent genes having runs of N inside. The \code{bypass.SD} turn off the search
for a Shine-Dalgarno motif.
}
\note{
The prodigal software must be installed on the system for this function to work, i.e. the command
\samp{system("prodigal -h")} must be recognized as a valid command if you run it in the Console window.
}
\examples{
\dontrun{
# This example requires the external prodigal software
# Using a genome file in this package.
genome.file <- file.path(path.package("microseq"),"extdata","small.fna")

# Searching for coding sequences, this is Mycoplasma (trans.tab = 4)
gff.tbl <- findGenes(genome.file, trans.tab = 4)

# Retrieving the sequences
genome <- readFasta(genome.file)
cds.tbl <- gff2fasta(gff.tbl, genome)
}

}
\seealso{
\code{\link{readGFF}}, \code{\link{gff2fasta}}.
}
\author{
Lars Snipen and Kristian Hovde Liland.
}
