% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_cip.R
\name{filter_cip}
\alias{filter_cip}
\title{Subset rows that include matches to search strings}
\usage{
filter_cip(keep_text = NULL, ..., drop_text = NULL, cip = NULL, select = NULL)
}
\arguments{
\item{keep_text}{Character vector of search text for retaining rows,
not case-sensitive. Can be empty if \code{drop_text} is used.}

\item{...}{Not used, force later arguments to be used by name}

\item{drop_text}{Optional character vector of search text for dropping
rows, default NULL.}

\item{cip}{Data frame to be searched. Default \code{cip}.}

\item{select}{Optional character vector of column names to return,
default all columns.}
}
\value{
A \code{data.table} subset of \code{cip} with the following properties:
\itemize{
\item Rows matching elements of \code{keep_text} but excluding rows
matching elements of \code{drop_text}.
\item All columns or those specified by \code{select}.
\item Grouping structures are not preserved.
}
}
\description{
Subset a CIP data frame, retaining rows that match or partially match a
vector of character strings. Columns are not subset unless selected in an
optional argument.
}
\details{
Search terms can include regular expressions. Uses \code{grepl()}, therefore
non-character columns (if any) that can be coerced to character are also
searched for matches. Columns are subset by the values in \code{select} after the
search concludes.

If none of the optional arguments are specified, the function returns the
original data frame.
}
\examples{
# Subset using keywords
filter_cip(keep_text = "engineering")

\donttest{
    # Multiple passes to narrow the results
    first_pass <- filter_cip("civil")
    second_pass <- filter_cip("engineering", cip = first_pass)
    filter_cip(drop_text = "technology", cip = second_pass)
    
    # drop_text argument, when used, must be named
    filter_cip("civil engineering", drop_text = "technology")
    
    # Subset using numerical codes
    filter_cip(keep_text = c("050125", "160501"))
    
    # Subset using regular expressions
    filter_cip(keep_text = "^54")
    filter_cip(keep_text = c("^1407", "^1408"))
    
    # Select columns
    filter_cip(keep_text = "^54", select = c("cip6", "cip4name"))
}
}
\concept{filter_*}
