% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RecombinatorNull.R
\name{dict_recombinators_null}
\alias{dict_recombinators_null}
\alias{RecombinatorNull}
\title{Null-Recombinator}
\description{
Null-recombinator that does not perform any operation on its input. Useful in particular with operator-wrappers such as \code{\link{RecombinatorMaybe}} or
\code{\link{RecombinatorCombination}}.

\code{n_indivs_in} and \code{n_indivs_out} can be set during construction, where \code{n_indivs_out} must be less or equal \code{n_indivs_in}. If it is strictly less,
then the operation returns only the first \code{n_indivs_out} individuals out of each \code{n_indivs_in} sized group.
}
\section{Configuration Parameters}{

This operator has no configuration parameters.
}

\section{Supported Operand Types}{


Supported \code{\link[paradox:Param]{Param}} classes are: \code{\link[paradox:ParamLgl]{ParamLgl}}, \code{\link[paradox:ParamInt]{ParamInt}}, \code{\link[paradox:ParamDbl]{ParamDbl}}, \code{\link[paradox:ParamFct]{ParamFct}}
}

\section{Dictionary}{

This \code{\link{Recombinator}} can be created with the short access form \code{\link[=rec]{rec()}}
(\code{\link[=recs]{recs()}} to get a list), or through the the \link[mlr3misc:Dictionary]{dictionary}
\code{\link{dict_recombinators}} in the following way:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# preferred:
rec("null")
recs("null")  # takes vector IDs, returns list of Recombinators

# long form:
dict_recombinators$get("null")
}\if{html}{\out{</div>}}
}

\examples{
rn = rec("null")
p = ps(x = p_int(-5, 5), y = p_dbl(-5, 5), z = p_lgl())
data = data.frame(x = 1:4, y = 0:3, z = rep(TRUE, 4))

rn$prime(p)
rn$operate(data)

rn_half = rec("null", n_indivs_in = 2, n_indivs_out = 1)
rn_half$prime(p)
rn_half$operate(data)
}
\seealso{
Other recombinators: 
\code{\link{OperatorCombination}},
\code{\link{RecombinatorPair}},
\code{\link{Recombinator}},
\code{\link{dict_recombinators_cmpmaybe}},
\code{\link{dict_recombinators_convex}},
\code{\link{dict_recombinators_cvxpair}},
\code{\link{dict_recombinators_maybe}},
\code{\link{dict_recombinators_proxy}},
\code{\link{dict_recombinators_sbx}},
\code{\link{dict_recombinators_sequential}},
\code{\link{dict_recombinators_swap}},
\code{\link{dict_recombinators_xonary}},
\code{\link{dict_recombinators_xounif}}
}
\concept{recombinators}
\section{Super classes}{
\code{\link[miesmuschel:MiesOperator]{miesmuschel::MiesOperator}} -> \code{\link[miesmuschel:Recombinator]{miesmuschel::Recombinator}} -> \code{RecombinatorNull}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RecombinatorNull-new}{\code{RecombinatorNull$new()}}
\item \href{#method-RecombinatorNull-clone}{\code{RecombinatorNull$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="help"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-help'><code>miesmuschel::MiesOperator$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="operate"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-operate'><code>miesmuschel::MiesOperator$operate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="prime"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-prime'><code>miesmuschel::MiesOperator$prime()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="print"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-print'><code>miesmuschel::MiesOperator$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="repr"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-repr'><code>miesmuschel::MiesOperator$repr()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RecombinatorNull-new"></a>}}
\if{latex}{\out{\hypertarget{method-RecombinatorNull-new}{}}}
\subsection{Method \code{new()}}{
Initialize base class components of the \code{Recombinator}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RecombinatorNull$new(n_indivs_in = 1, n_indivs_out = n_indivs_in)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n_indivs_in}}{(\code{integer(1)})\cr
Number of individuals to consider at the same time. When operating, the number of input individuals must be divisible by this number.
Setting this number to a number unequal 1 is mostly useful when incorporating this operator in wrappers such as \code{\link{RecombinatorMaybe}} or
\code{\link{RecombinatorCombination}}.
Default 1.\cr
The \verb{$n_indivs_in} field will reflect this value.}

\item{\code{n_indivs_out}}{(\code{integer(1)})\cr
Number of individuals that result for each \code{n_indivs_in} lines of input. Must be at most \code{n_indivs_in}. If this is less than \code{n_indivs_in},
then only the first \code{n_indivs_out} individuals out of each \code{n_indivs_in} sized group are returned by an operation.
Setting this number to a number unequal 1 is mostly useful when incorporating this operator in wrappers such as \code{\link{RecombinatorMaybe}} or
\code{\link{RecombinatorCombination}}.
Default equal to \code{n_indivs_in}.\cr
The \verb{$n_indivs_out} field will reflect this value.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RecombinatorNull-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RecombinatorNull-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RecombinatorNull$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
