% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TerminatorGenerations.R
\name{mlr_terminators_gens}
\alias{mlr_terminators_gens}
\alias{TerminatorGenerations}
\title{Terminator that Counts OptimizerMies Generations}
\description{
\code{\link[bbotk:Terminator]{Terminator}} that terminates after a given number of generations have passed in \code{\link{OptimizerMies}}.

If \code{\link{OptimizerMies}} is started on an archive that already has evaluated configurations, these evaluations count as
generation 0. If an initial, randomly sampled generation is generated by \code{\link{OptimizerMies}}, it has generation number 1.
Setting \code{generation} to 1 therefore terminates after the evaluation of the initial sample, \emph{unless} no initial sample is
generated by \code{\link{OptimizerMies}} and instead found in the archive. \code{generation} set to 0 avoids any evaluation within \code{\link{OptimizerMies}}
(but is ignored if no \code{dob} column is in the archive).

When doing multi-fidelity optimization, and fidelity of a configuration is increased because of a step in the fidelity schedule,
or because they were sampled new and survived, then this fidelity refinement happens as part of an already started generation. This means
termination at this fidelity refinement step is avoided.
}
\section{Dictionary}{

This \code{\link[bbotk:Terminator]{Terminator}} can be created with the short access form \code{\link[bbotk:trm]{trm()}} (\code{\link[bbotk:trm]{trms()}} to get a list),
or through the \link[mlr3misc:Dictionary]{dictionary} \code{\link[bbotk:mlr_terminators]{mlr_terminators}} in the following way:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# preferred
trm("gens")
trms("gens")  # takes vector IDs, returns list of Terminators

# long form
mlr_terminators$get("gens")
}\if{html}{\out{</div>}}
}

\section{Configuration Parameters}{

\itemize{
\item \code{generations} :: \code{integer(1)}\cr
Number of generations to evaluate, after which to stop. Not initialized and should be set to the desired value during construction.
}
}

\examples{
library("bbotk")
trm("gens", generations = 10)
}
\section{Super class}{
\code{\link[bbotk:Terminator]{bbotk::Terminator}} -> \code{TerminatorGenerations}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TerminatorGenerations-new}{\code{TerminatorGenerations$new()}}
\item \href{#method-TerminatorGenerations-is_terminated}{\code{TerminatorGenerations$is_terminated()}}
\item \href{#method-TerminatorGenerations-clone}{\code{TerminatorGenerations$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Terminator" data-id="format"><a href='../../bbotk/html/Terminator.html#method-Terminator-format'><code>bbotk::Terminator$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Terminator" data-id="print"><a href='../../bbotk/html/Terminator.html#method-Terminator-print'><code>bbotk::Terminator$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Terminator" data-id="remaining_time"><a href='../../bbotk/html/Terminator.html#method-Terminator-remaining_time'><code>bbotk::Terminator$remaining_time()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Terminator" data-id="status"><a href='../../bbotk/html/Terminator.html#method-Terminator-status'><code>bbotk::Terminator$status()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TerminatorGenerations-new"></a>}}
\if{latex}{\out{\hypertarget{method-TerminatorGenerations-new}{}}}
\subsection{Method \code{new()}}{
Initialize the \code{TerminatorGenerations} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TerminatorGenerations$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TerminatorGenerations-is_terminated"></a>}}
\if{latex}{\out{\hypertarget{method-TerminatorGenerations-is_terminated}{}}}
\subsection{Method \code{is_terminated()}}{
Is \code{TRUE} if when the termination criterion is matched, \code{FALSE} otherwise.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TerminatorGenerations$is_terminated(archive)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{archive}}{\code{\link[bbotk:Archive]{Archive}}
Archive to check.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{logical(1)}: Whether to terminate.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TerminatorGenerations-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TerminatorGenerations-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TerminatorGenerations$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
