% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RecombinatorConvexPair.R
\name{dict_recombinators_cvxpair}
\alias{dict_recombinators_cvxpair}
\alias{RecombinatorConvexPair}
\title{Convex Combination Recombinator for Pairs}
\description{
Numeric Values between various individuals are recombined via component-wise convex combination (or weighted mean). Exactly two
individuals are being recombined, and the \code{lambda} configuration parameter determines the relative weight of the first
individual in each pair for the first result, and the relative weight of the second indivudual for the complement, if
initialized with \code{keep_complement} set to \code{TRUE}.
}
\section{Configuration Parameters}{

\itemize{
\item \code{lambda} :: \code{numeric}\cr
Combination weight. If \code{keep_complement} is \code{TRUE}, then two individuals are returned for each pair of input individuals:
one corresponding to \verb{lambda * <1st individual> + (1-lambda) * <2nd individual>}, and one corresponding to
\verb{(1-lambda) * <1st individual> + lambda * <2nd individual>} (i.e. the complement). Otherwise, only the first of these two
is generated.
Must either be a scalar, or a vector with length equal to the number of
components in the values being operated on. Must be between 0 and 1.\cr
Initialized to 0.5.
}
}

\section{Supported Operand Types}{


Supported \code{\link[paradox:Domain]{Domain}} classes are: \code{\link[paradox:Domain]{p_dbl}} ('ParamDbl')
}

\section{Dictionary}{

This \code{\link{Recombinator}} can be created with the short access form \code{\link[=rec]{rec()}}
(\code{\link[=recs]{recs()}} to get a list), or through the the \link[mlr3misc:Dictionary]{dictionary}
\code{\link{dict_recombinators}} in the following way:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# preferred:
rec("convex")
recs("convex")  # takes vector IDs, returns list of Recombinators

# long form:
dict_recombinators$get("convex")
}\if{html}{\out{</div>}}
}

\examples{
set.seed(1)
rcvx = rec("cvxpair")
p = ps(x = p_dbl(-5, 5), y = p_dbl(-5, 5), z = p_dbl(-5, 5))
data = data.frame(x = 0:5, y = 0:5, z = 0:5)

rcvx$prime(p)
rcvx$operate(data)  # mean of groups of 2
# with the default value of lambda = 0.5, the default of
# keep_complement = TRUE means that pairs of equal values are generated;
# consider setting keep_complement = FALSE int that case.

rcvx$param_set$values$lambda = 0.1
rcvx$operate(data)

}
\seealso{
Other recombinators: 
\code{\link{OperatorCombination}},
\code{\link{Recombinator}},
\code{\link{RecombinatorPair}},
\code{\link{dict_recombinators_cmpmaybe}},
\code{\link{dict_recombinators_convex}},
\code{\link{dict_recombinators_maybe}},
\code{\link{dict_recombinators_null}},
\code{\link{dict_recombinators_proxy}},
\code{\link{dict_recombinators_sbx}},
\code{\link{dict_recombinators_sequential}},
\code{\link{dict_recombinators_swap}},
\code{\link{dict_recombinators_xonary}},
\code{\link{dict_recombinators_xounif}}
}
\concept{recombinators}
\section{Super classes}{
\code{\link[miesmuschel:MiesOperator]{miesmuschel::MiesOperator}} -> \code{\link[miesmuschel:Recombinator]{miesmuschel::Recombinator}} -> \code{\link[miesmuschel:RecombinatorPair]{miesmuschel::RecombinatorPair}} -> \code{RecombinatorConvexPair}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RecombinatorConvexPair-new}{\code{RecombinatorConvexPair$new()}}
\item \href{#method-RecombinatorConvexPair-clone}{\code{RecombinatorConvexPair$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="help"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-help'><code>miesmuschel::MiesOperator$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="operate"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-operate'><code>miesmuschel::MiesOperator$operate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="prime"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-prime'><code>miesmuschel::MiesOperator$prime()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="print"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-print'><code>miesmuschel::MiesOperator$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="repr"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-repr'><code>miesmuschel::MiesOperator$repr()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RecombinatorConvexPair-new"></a>}}
\if{latex}{\out{\hypertarget{method-RecombinatorConvexPair-new}{}}}
\subsection{Method \code{new()}}{
Initialize the \code{RecombinatorConvexPair} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RecombinatorConvexPair$new(keep_complement = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keep_complement}}{(\code{logical(1)})\cr
Whether the operation should keep both resulting individuals (\code{TRUE}), or only the first and discard
the complement (\code{FALSE}). Default \code{TRUE}.
The \verb{$keep_complement} field will reflect this value.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RecombinatorConvexPair-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RecombinatorConvexPair-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RecombinatorConvexPair$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
