% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_mo.R
\name{domhv_contribution}
\alias{domhv_contribution}
\title{Calculate Hypervolume Contribution}
\usage{
domhv_contribution(fitnesses, nadir = 0, epsilon = 0)
}
\arguments{
\item{fitnesses}{(\verb{numeric matrix})\cr
fitness matrix, with one row per individual and one column per objective}

\item{nadir}{(\code{numeric})\cr
Lowest fitness point up to which to calculate dominated hypervolume. May be a scalar, in which case
it is used for all dimensions, or a vector, in which case its length must match the number of dimensions.
Default 0.}

\item{epsilon}{(\code{numeric})\cr
Added to each individual before calculating its particular hypervolume contribution. \code{epsilon} may
be a scalar, in which case it is used for all dimensions, or a vector, in which case its length must match
the number of dimensions. Default 0.}
}
\value{
\code{numeric}: The vector of dominated hypervolume contributions for each individual in \code{fitnesses}.
}
\description{
Takes a \code{matrix} of fitness values and calculates the hypervolume contributions of individuals in that \code{matrix}.

Hypervolume contribution of an individual I is the difference between the dominated hypervolume of a set of
individuals including I, where the fitness of I is increased by \code{epsilon}, and the dominated hypervolume of
the same set but excluding I.

Individuals that are less than another individual more than \code{epsilon} in any dimension have hypervolume contribution
of 0.
}
\examples{
(fitnesses = matrix(c(1, 5, 2, 3, 0, 3, 1, 0, 10, 8), ncol = 2))

# to see the fitness matrix, use:
## plot(fitnesses, pch = as.character(1:5))

domhv_contribution(fitnesses)
}
