% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viz_ggevolution.R
\name{ggevolution}
\alias{ggevolution}
\title{Plot the evolution of a network}
\usage{
ggevolution(..., layout = "kk", based_on = c("first", "last", "both"))
}
\arguments{
\item{...}{two or more networks}

\item{layout}{an igraph layout. Default is Kamada-Kawai ("kk")}

\item{based_on}{whether the layout of the joint plots should
be based on the "first" or the "last" network.}
}
\description{
This function offers a method to plot a network
at two or more timepoints for quick and easy comparison.
The function is currently limited to two networks
and only the layout given by the first or last network,
but further extensions expected.
}
\examples{
mpn_elite_mex <- mpn_elite_mex \%>\% to_subgraph(in_mpn == 1)
mpn_elite_mex2 <- generate_permutation(mpn_elite_mex)
ggevolution(mpn_elite_mex, mpn_elite_mex2)
ggevolution(mpn_elite_mex, mpn_elite_mex2, based_on = "last")
ggevolution(mpn_elite_mex, mpn_elite_mex2, based_on = "both")
}
