% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/census.R
\name{census}
\alias{census}
\alias{node_tie_census}
\alias{node_triad_census}
\alias{node_quad_census}
\alias{group_tie_census}
\alias{group_triad_census}
\title{Census by nodes or clusters}
\usage{
node_tie_census(object)

node_triad_census(object)

node_quad_census(object)

group_tie_census(object, clusters, decimals = 2)

group_triad_census(object, clusters, decimals = 2)
}
\arguments{
\item{object}{An object of a migraph-consistent class:
\itemize{
\item matrix, from base R
\item edgelist, a data frame from base R or tibble from tibble
\item igraph, from the igraph package
\item network, from the network package
\item tbl_graph, from the tidygraph package
}}

\item{clusters}{a vector of cluster assignment.}

\item{decimals}{Number of decimal points to round to.}
}
\description{
These functions include ways to take a census of the positions of nodes
in a network. These include a triad census based on the triad profile
of nodes, but also a tie census based on the particular tie partners
of nodes. Included also are group census functions for summarising
the profiles of clusters of nodes in a network.
}
\details{
The quad census uses the \code{{oaqc}} package to do
the heavy lifting of counting the number of each orbits.
See \code{vignette('oaqc')}.
However, our function relabels some of the motifs
to avoid conflicts and improve some consistency with
other census-labelling practices.
The letter-number pairing of these labels indicate
the number and configuration of ties.
For now, we offer a rough translation:\tabular{ll}{
   migraph \tab Ortmann and Brandes \cr
   E4 \tab co-K4 \cr
   I40, I41 \tab co-diamond \cr
   H4 \tab co-C4 \cr
   L42, L41, L40 \tab co-paw \cr
   D42, D40 \tab co-claw \cr
   U42, U41 \tab P4 \cr
   Y43, Y41 \tab claw \cr
   P43, P42, P41 \tab paw \cr
   04 \tab C4 \cr
   Z42, Z43 \tab diamond \cr
   X4 \tab K4 \cr
}
}
\section{Functions}{
\itemize{
\item \code{node_quad_census}: Returns a census of nodes' positions
in motifs of four nodes.
}}

\examples{
task_eg <- to_named(to_uniplex(ison_algebra, "task_tie"))
(tie_cen <- node_tie_census(task_eg))
(triad_cen <- node_triad_census(task_eg))
(quad_cen <- node_quad_census(ison_southern_women))
group_tie_census(task_eg, cutree(cluster_structural_equivalence(task_eg), 4))
group_triad_census(task_eg, cutree(cluster_regular_equivalence(task_eg), 4))
}
\references{
Ortmann, Mark, and Ulrik Brandes. 2017.
“Efficient Orbit-Aware Triad and Quad Census in Directed and Undirected Graphs.”
\emph{Applied Network Science} 2(1):13. \doi{https://doi.org/10.1007/s41109-017-0027-2}
}
