% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/migrate.R
\name{migrate}
\alias{migrate}
\title{Summarize the migration of a data frame}
\usage{
migrate(
  data,
  date,
  rating,
  metric,
  percent = FALSE,
  id = NULL,
  include.new = TRUE,
  exclude.old = FALSE
)
}
\arguments{
\item{data}{A data frame or data frame extension (e.g., a tibble or data.table)
containing a minimum of three (3) column variables representing a date, a credit
risk rating, and a (continuous) metric.}

\item{date}{A symbol or string, representing the column variable of the `data` data
frame argument that contains the two unique date values.}

\item{rating}{A symbol or string, representing the column variable of the `data` data
frame argument that contains the credit risk rating values.}

\item{metric}{A symbol or string, representing the column variable of the `data` data
frame argument that contains the continuous metric values.}

\item{percent}{If `TRUE`, will compute the percentage change in the continuous metric
instead of just using the absolute difference.}

\item{id}{(Required if `include.new = FALSE` or `exclude.old = TRUE`) A symbol or
string, representing the column variable of the `data` data frame argument that
contains the ID values (e.g., "Customer ID", "Loan ID", etc.).}

\item{include.new}{If `FALSE`, will remove ID's that only have an observation for the
later date.}

\item{exclude.old}{If `TRUE`, will remove ID's that only have an observation for the
earlier date.}
}
\value{
A data frame containing three (3) column variables representing the unique
combinations of starting & ending credit risk ratings and the migrated difference in
the continuous metric.
}
\description{
`migrate()` summarizes the transition amount (or percentage) of a continuous variable
from each beginning credit risk rating category to each ending credit risk rating,
given a data frame input.
}
\examples{
# Return the absolute difference in `principal_balance`
mock_credit \%>\%
  migrate(
    date = date,
    rating = risk_rating,
    metric = principal_balance
  )

# Return the percent difference in `principal_balance` while excluding "new"
# `customer_id` values
mock_credit \%>\%
  migrate(
    date = date,
    rating = risk_rating,
    metric = principal_balance,
    percent = TRUE,
    id = customer_id,
    include.new = FALSE
  )

}
