% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/individual.R
\name{markmap}
\alias{markmap}
\title{Create a mind map in HTML widget}
\usage{
markmap(
  from = ".",
  root = NA,
  input_type = c("auto", "markdown", "mindmap", "R", "dir"),
  md_list = FALSE,
  md_eq = FALSE,
  md_braces = FALSE,
  md_bookdown = FALSE,
  md_maxlevel = "",
  dir_files = TRUE,
  dir_all = TRUE,
  dir_excluded = NA,
  widget_name = NA,
  widget_width = NULL,
  widget_height = NULL,
  widget_elementId = NULL,
  widget_options = markmapOption(preset = "colorful")
)
}
\arguments{
\item{from}{Character. The source text of the (R) Markdown syntax text, the R code, the FreeMind mind map code, or the path to the directory.}

\item{root}{Character. The string displayed as the root (center) of the mind map.}

\item{input_type}{Character. The type of the input text. It can be \code{'auto', 'markdown', 'mindmap', 'R', 'dir'}. The default value is \code{'auto'}, which means the type will be automatically assgined according to the features of the input text.}

\item{md_list}{Logical. whether to process lists like headings in the Markdown input.}

\item{md_eq}{Logical. Whether to include LaTeX equations in the Markdown input when converted to other formats.}

\item{md_braces}{Logical. Whether to remove \href{https://bookdown.org/yihui/bookdown/cross-references.html}{{#ID}} in the headings of the markdown file (usually in a \href{https://github.com/rstudio/bookdown}{bookdown}> project.}

\item{md_bookdown}{Logical. Whether the R Markdown syntax text is in bookdown style, i.e. \code{# (PART), # (APPENDIX)}, and \code{# References} as an upper level of the Level 1 heading.}

\item{md_maxlevel}{Integer or ''. The maximum level of the markdown headings that are displayed in the mind map.}

\item{dir_files}{Logical. Whether to include files. If \code{FALSE}, only folders are included. If \code{TRUE}, folders and files are included.}

\item{dir_all}{Logical. Whether to include all files in a directory. If \code{FALSE}, only the names of visible files are included (following Unix-style visibility, that is files whose name does not start with a dot). If \code{TRUE}, all file names will be included.}

\item{dir_excluded}{Character. The directories which are not included in the output.}

\item{widget_name}{Character. The name of the html widget.}

\item{widget_width}{Numeric. The width of the widget.}

\item{widget_height}{Numeric. The height of the widget.}

\item{widget_elementId}{Character. The ID of teh Widget.}

\item{widget_options}{List. Options for the markmap widget. It should be a list passed from the \code{markmapOption()} function.}
}
\value{
HTML widget object.
}
\description{
Create a mind map in HTML widget
}
\details{
This function, adapted from the \href{https://github.com/seifer08ms/Rmarkmap}{Rmarkup} package, creates a markmap widget using htmlwidgets. The widget can be rendered on HTML pages generated from R Markdown, Shiny,or other applications.
}
\examples{
# Display Markdown:
input <- system.file("examples/mindr-md.Rmd", package = "mindr")
# file.show(input)
input_txt <- readLines(input, encoding = "UTF-8")
markmap(input_txt)
markmap(input_txt, root = basename(input), md_list = TRUE, md_eq = FALSE,
    md_braces = FALSE, md_bookdown = TRUE)

# Display Mind Map:
input <- system.file("examples/mindr-mm.mm", package = "mindr")
# file.show(input)
input_txt <- readLines(input, encoding = "UTF-8")
markmap(input_txt)
markmap(input_txt, root = basename(input))

# Display R script:
input <- system.file("examples/mindr-r.R", package = "mindr")
# file.show(input)
from <- input_txt <- readLines(input, encoding = "UTF-8")
markmap(input_txt)
markmap(input_txt, root = basename(input), md_list = TRUE, md_eq = FALSE,
    md_braces = FALSE, md_bookdown = TRUE)

# Display directory:
input <- system.file(package = "mindr")
markmap(input)
markmap(input, root = "The mindr package", dir_files = FALSE, dir_excluded = c("Meta",
    "htmlwidgets/lib"), widget_elementId = "mindr-dir")
}
