% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirtCluster.R
\name{mirtCluster}
\alias{mirtCluster}
\title{Define a parallel cluster object to be used in internal functions}
\usage{
mirtCluster(spec, ..., remove = FALSE)
}
\arguments{
\item{spec}{input that is passed to \code{parallel::makeCluster()}. If no input is given the
maximum number of available local cores will be used}

\item{...}{additional arguments to pass to \code{parallel::makeCluster}}

\item{remove}{logical; remove previously defined \code{mirtCluster()}?}
}
\description{
This function defines a object that is placed in a relevant internal environment defined in mirt.
Internal functions such as \code{calcLogLik}, \code{fscores}, etc, will utilize this object
automatically to capitalize on parallel
processing architecture. The object defined is a call from \code{parallel::makeCluster()}.
Note that if you are defining other parallel objects (for simulation designs, for example)
it is not recommended to define a mirtCluster.
}
\examples{

\dontrun{

#make 4 cores available for parallel computing
mirtCluster(4)

#' #stop and remove cores
mirtCluster(remove = TRUE)

}
}
\references{
Chalmers, R., P. (2012). mirt: A Multidimensional Item Response Theory
Package for the R Environment. \emph{Journal of Statistical Software, 48}(6), 1-29.
\doi{10.18637/jss.v048.i06}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
\keyword{parallel}
