context('mirtTwo')

test_that('poly', {
    modp1 <- mirt(Science, 1, verbose=FALSE)
    expect_is(modp1, 'SingleGroupClass')
    expect_equal(extract.mirt(modp1, 'df'), 239)
    cfs <- as.numeric(do.call(c, coef(modp1)))
    expect_equal(cfs, c(1.041, 4.864, 2.64, -1.466, 1.226, 2.924, 0.901, -2.266, 2.296, 5.238, 2.216, -1.965, 1.095, 3.348, 0.992, -1.688, 0, 1),
                 tolerance = 1e-2)
    C2 <- M2(modp1, type = 'C2')
    expect_equal(C2$M2, .2891394, tolerance=1e-4)
    expect_equal(C2$p, .8653946, tolerance=1e-4)
    modp2 <- mirt(Science, 1, 'sequential', verbose=FALSE)
    expect_is(modp2, 'SingleGroupClass')
    expect_equal(extract.mirt(modp2, 'df'), 239)
    cfs <- as.numeric(do.call(c, coef(modp2)))
    expect_equal(cfs, c(0.997414,4.831609,2.750703,-1.365844,1.067633,2.815793,1.104466,-1.87485,2.132679,5.021663,2.223683,-1.784284,0.9942698,3.287169,1.12849,-1.308458,0,1),
                 tolerance = 1e-2)
    expect_equal(logLik(modp2), -1609.768, tolerance = 1e-4)

    modLouis <- mirt(Science, 1, SE=T, SE.type='Louis', verbose=FALSE)
    expect_is(modp1, 'SingleGroupClass')
    cfs <- as.numeric(do.call(c, coef(modLouis, printSE=TRUE)))
    expect_equal(cfs, c(1.04236, 0.18838, 4.86544, 0.49088, 2.64044, 0.22267, -1.46621, 0.15868, 1.22569, 0.18189, 2.924, 0.23928, 0.90115, 0.14289, -2.26661, 0.20308, 2.29058, 0.48269, 5.22988, 0.72817, 2.21201, 0.3564, -1.96222, 0.32209, 1.09557, 0.18336, 3.34845, 0.27659, 0.9919, 0.14053, -1.68846, 0.16864, 0, NA, 1, NA),
                 tolerance = 1e-3)
    expect_equal(modLouis@OptimInfo$condnum, 98.26492, tolerance = 1e-2)
    modsandwich <- mirt(Science, 1, SE=T, SE.type='sandwich.Louis', verbose=FALSE)
    expect_is(modsandwich, 'SingleGroupClass')
    cfs <- as.numeric(do.call(c, coef(modsandwich, printSE=TRUE)))
    expect_equal(cfs, c(1.04236, 0.23843, 4.86544, 0.46794, 2.64044, 0.24659, -1.46621, 0.17162, 1.22569, 0.1922, 2.924, 0.24655, 0.90115, 0.14592, -2.26661, 0.19899, 2.29058, 0.52026, 5.22988, 0.80736, 2.21201, 0.373, -1.96222, 0.33683, 1.09557, 0.22701, 3.34845, 0.29203, 0.9919, 0.14491, -1.68846, 0.18015, 0, NA, 1, NA),
                 tolerance = 1e-3)
    expect_equal(extract.mirt(modsandwich, 'condnum'), 141.5391, tolerance = 1e-2)
    modsandwich <- mirt(Science, 1, SE=T, SE.type='sandwich', verbose=FALSE)
    expect_is(modsandwich, 'SingleGroupClass')
    cfs <- as.numeric(do.call(c, coef(modsandwich, printSE=TRUE)))
    expect_equal(cfs, c(1.04236, 0.23843, 4.86544, 0.46794, 2.64044, 0.24659, -1.46621, 0.17162, 1.22569, 0.1922, 2.924, 0.24655, 0.90115, 0.14592, -2.26661, 0.19899, 2.29058, 0.52026, 5.22988, 0.80736, 2.21201, 0.373, -1.96222, 0.33683, 1.09557, 0.22701, 3.34845, 0.29203, 0.9919, 0.14491, -1.68846, 0.18015, 0, NA, 1, NA),
                 tolerance = 1e-3)
    expect_equal(extract.mirt(modsandwich, 'condnum'), 141.5346, tolerance = 1e-2)
    modOakes <- mirt(Science, 1, SE=T, SE.type='Oakes', verbose=FALSE)
    expect_equal(modOakes@OptimInfo$condnum, 97.8644, tolerance = 1e-4)
    modp1 <- mirt(Science, 1, verbose=FALSE)
    expect_is(modp1, 'SingleGroupClass')
    expect_equal(extract.mirt(modp1, 'df'), 239)
    cfs <- as.numeric(do.call(c, coef(modp1)))
    expect_equal(cfs, c(1.041, 4.864, 2.64, -1.466, 1.226, 2.924, 0.901, -2.266, 2.296, 5.238, 2.216, -1.965, 1.095, 3.348, 0.992, -1.688, 0, 1),
                 tolerance = 1e-2)
    vals <- mirt(Science, 1, large = TRUE, verbose=FALSE)
    modp1 <- mirt(Science, 1, large = vals, verbose=FALSE)
    expect_is(modp1, 'SingleGroupClass')
    cfs <- as.numeric(do.call(c, coef(modp1)))
    expect_equal(cfs, c(1.041, 4.864, 2.64, -1.466, 1.226, 2.924, 0.901, -2.266, 2.296, 5.238, 2.216, -1.965, 1.095, 3.348, 0.992, -1.688, 0, 1),
                 tolerance = 1e-2)
    modp1 <- mirt(Science, 1, SE=TRUE, SE.type = 'SEM', verbose=FALSE)
    expect_is(modp1, 'SingleGroupClass')
    expect_equal(extract.mirt(modp1, 'condnum'), 108.8042, tolerance = 1e-2)
    cfs <- as.numeric(do.call(c, coef(modp1)))
    expect_equal(cfs, c(1.041, 0.656, 1.425, 4.863, 3.849, 5.876, 2.639, 2.196, 3.083, -1.466, -1.782, -1.149, 1.226, 0.887, 1.565, 2.924, 2.45, 3.398, 0.901, 0.614, 1.188, -2.266, -2.639, -1.894, 2.3, 1.325, 3.275, 5.244, 3.804, 6.685, 2.218, 1.488, 2.949, -1.967, -2.605, -1.329, 1.094, 0.727, 1.461, 3.347, 2.801, 3.893, 0.991, 0.717, 1.266, -1.688, -2.018, -1.357, 0, NA, NA, 1, NA, NA),
                 tolerance = 1e-2)
    modp2 <- mirt(Science, 2, verbose=FALSE)
    expect_is(modp2, 'SingleGroupClass')
    expect_equal(modp2@Fit$df, 236)
    cfs <- as.numeric(do.call(c, coef(modp2, verbose=FALSE)))
    expect_equal(abs(cfs), abs(c(-1.3278,0.1081,5.1934,2.8583,-1.5996,-0.8762,1.8783,3.7248,1.1598,-2.9225,-1.4614,1.1639,4.6495,1.951,-1.7322,-1.7397,0,4.0053,1.2008,-2.0548,0,0,1,0,1)),
                 tolerance = 1e-2)
    modp3 <- mirt(Science, 1, constrain = list(c(1,5)), parprior = list(c(4,'norm',0,1)), verbose=FALSE)
    expect_is(modp3, 'SingleGroupClass')
    cfs <- as.numeric(do.call(c, coef(modp3, verbose = FALSE)))
    expect_true(mirt:::closeEnough(cfs - c(1.134,4.964,2.711,-1.473,1.134,2.865,0.882,-2.205,2.211,5.136,2.171,-1.91,1.129,3.383,1.006,-1.7,0,1),
                 -1e-2, 1e-2))
    newmodel <- mirt.model('F = 1-4
                           CONSTRAIN = (1-2,a1)
                           PRIOR = (1, d1, norm, 4, 1)')
    modp3 <- mirt(Science, newmodel, verbose=FALSE)
    expect_is(modp3, 'SingleGroupClass')
    cfs <- as.numeric(do.call(c, coef(modp3, verbose = FALSE)))
    expect_true(mirt:::closeEnough(cfs - c(1.132,4.795,2.677,-1.507,1.132,2.856,0.874,-2.211,2.216,5.127,2.16,-1.927,1.128,3.374,0.999,-1.707,0,1),
                                   -1e-2, 1e-2))
    modOakes <- mirt(Science, newmodel, SE=T, SE.type='Oakes', verbose=FALSE)
    expect_equal(modOakes@OptimInfo$condnum, 106.0775, tolerance = 1e-4)

    modp4 <- mirt(Science, 1, itemtype = c(rep('graded',3), 'nominal'), verbose=FALSE)
    expect_is(modp4, 'SingleGroupClass')
    cfs <- as.numeric(do.call(c, coef(modp4, verbose = FALSE)))
    expect_equal(cfs, c(1.0408, 4.862, 2.6387, -1.4664, 1.2063, 2.9083, 0.8958, -2.254, 2.3376, 5.2972, 2.2404, -1.9886, 0.7986, 0, 1.0782, 1.7756, 3, 0, 2.1964, 2.9637, 1.6742, 0, 1),
                 tolerance = 1e-2)
    modp5 <- mirt(Science, 1, itemtype = c(rep('graded',3), 'gpcm'), SE = TRUE, SE.type = 'SEM', verbose=FALSE)
    expect_is(modp5, 'SingleGroupClass')
    cfs <- as.numeric(do.call(c, coef(modp5, verbose = FALSE)))
    expect_equal(cfs, c(1.057,0.659,1.454,4.876,3.908,5.844,2.65,2.206,3.093,-1.472,-1.799,-1.146,1.219,0.865,1.573,2.918,2.444,3.391,0.9,0.615,1.185,-2.263,-2.662,-1.864,2.254,1.244,3.265,5.177,3.606,6.747,2.19,1.395,2.985,-1.942,-2.587,-1.298,0.771,0.441,1.1,0,NA,NA,1,NA,NA,2,NA,NA,3,NA,NA,0,NA,NA,2.16,1.537,2.782,2.973,2.276,3.671,1.767,1.128,2.407,0,NA,NA,1,NA,NA),
                 tolerance = 1e-2)
    modp6 <- mirt(Science, 1, dentype="empiricalhist", verbose = FALSE, TOL=1e-3)
    expect_is(modp6, 'SingleGroupClass')
    cfs <- as.numeric(do.call(c, coef(modp6, verbose = FALSE)))
    expect_equal(cfs, c(0.856,5.072,2.639,-1.35,1.095,2.951,0.968,-2.181,2.601,5.541,2.634,-1.752,0.988,3.443,1.058,-1.595,0,1),
                 tolerance = 1e-2)

    fm0 <- fscores(modp1, method='EAP', response.pattern = c(1,2,3,4), full.scores=FALSE)
    expect_equal(as.numeric(fm0[,c('F1','SE_F1')]), c(-0.3494903, 0.6004922), tolerance=1e-4)
    fm1 <- fscores(modp1, verbose = FALSE, full.scores=FALSE)
    expect_is(fm1, 'matrix')
    expect_true(mirt:::closeEnough(fm1[1:6,'F1'] - c(-2.7488324, -1.4190140, -0.7154329, -0.4453752, -2.5438490, -1.2481072), -1e-2, 1e-2))
    fm1b <- fscores(modp1, verbose = FALSE, full.scores=TRUE)
    expect_equal(cor(fm1b, rowSums(Science))[1], .969, tolerance = .02)
    fm2 <- fscores(modp2, rotate = 'oblimin', verbose = FALSE, full.scores=FALSE)
    expect_is(fm2, 'matrix')
    expect_true(mirt:::closeEnough(abs(as.numeric(fm2[1:6,c('F1','F2')])) -
                                       c(2.5966,1.8668,0.6578,1.1597,2.4204,0.7001,2.412,0.8689,0.0258,0.2609,2.3376,1.4844),
                                   -1e-2, 1e-2))
    fm3 <- fscores(modp3, rotate = 'oblimin', full.scores = TRUE, verbose = FALSE)
    expect_is(fm3, 'matrix')
    fm4 <- fscores(modp4, verbose = FALSE, full.scores=FALSE)
    expect_is(fm4, 'matrix')
    expect_true(mirt:::closeEnough(fm4[1:6,'F1'] - c(-2.7320802, -1.4459303, -0.7910009, -0.5438761, -2.5310045, -1.1434060), -1e-2, 1e-2))
    fm5 <- fscores(modp5, verbose = FALSE, full.scores=FALSE)
    expect_is(fm5, 'matrix')
    expect_true(mirt:::closeEnough(fm5[1:6,'F1'] - c(-2.7249561, -1.4446593, -0.7364399, -0.5627047, -2.5174376, -1.1732461), -1e-2, 1e-2))

    resmat <- residuals(modp3, type = 'Q3', Theta = fm3[,'F1'], verbose = FALSE)
    expect_equal(as.numeric(resmat), c(1,-0.209,-0.283,0.057,-0.209,1,-0.149,-0.235,-0.283,-0.149,1,-0.33,0.057,-0.235,-0.33,1), tolerance=1e-2)
    resmatLD <- residuals(modp3, type = 'LD', verbose = FALSE)
    expect_equal(as.numeric(resmatLD), c(NA,-23.885,-12.788,22.164,-0.143,NA,10.449,-22.306,-0.104,0.094,NA,-17.526,0.137,-0.138,-0.122,NA), tolerance=1e-2)
    resmatG2 <- residuals(modp3, type = 'LDG2', verbose = FALSE)
    expect_equal(as.numeric(resmatG2), c(NA,-21.112,-10.523,19.915,-0.134,NA,10.257,-17.554,-0.095,0.093,NA,-18.397,0.13,-0.122,-0.125,NA), tolerance=1e-2)
    cof1 <- coef(modp1)
    expect_is(cof1, 'list')
    cof2 <- coef(modp2, verbose = FALSE)
    expect_is(cof2, 'list')
    IP1 <- itemplot(modp1, 1)
    IP2 <- itemplot(modp2, 1)
    expect_is(IP1, 'trellis')
    expect_is(IP2, 'trellis')
    fit <- suppressMessages(itemfit(modp2, c('S_X2', 'Zh')))
    expect_equal(fit$Zh, c(1.413226, 2.455924, 4.125340, 3.887814), tolerance=1e-4)
    expect_equal(fit$S_X2, c(3.941804,10.58528,6.913239,10.11068), tolerance=1e-4)
    fs <- fscores(modp1, method = 'WLE', verbose=FALSE, full.scores=FALSE)
    expect_equal(as.numeric(fs[1:3, 5:6]), c(-5.7024116, -2.1162737, -1.1386969,  1.5797286,
                                             0.6321478,  0.6544024), tolerance = 1e-4)

    ##rating scale test
    set.seed(1234)
    a <- matrix(rep(1, 10))
    d <- matrix(c(1,0.5,-.5,-1), 10, 4, byrow = TRUE)
    cc <- seq(-1, 1, length.out=10)
    data <- simdata(a, d + cc, 2000, itemtype = rep('graded',10))
    sv <- mirt(data, 1, itemtype = 'grsm', pars = 'values', verbose=FALSE)
    sv[,'value'] <- c(as.vector(t(cbind(a,d,cc))),0,1)
    grsm <- mirt(data, 1, itemtype = 'grsm', pars = sv, calcNull= FALSE, verbose=FALSE, TOL=1e-5)
#     rsm <- mirt(data, 1, itemtype = 'rsm', calcNull= FALSE, verbose=FALSE, TOL = 1e-3)
    expect_is(grsm, 'SingleGroupClass')
#     expect_is(rsm, 'SingleGroupClass')
    cfs <- as.numeric(do.call(c, coef(grsm, verbose = FALSE)))
    expect_equal(cfs, c(0.9832,1.0105,0.5093,-0.5105,-0.9939,-1,0.988,1.0105,0.5093,-0.5105,-0.9939,-0.78,1.0273,1.0105,0.5093,-0.5105,-0.9939,-0.5669,0.9417,1.0105,0.5093,-0.5105,-0.9939,-0.2953,0.9658,1.0105,0.5093,-0.5105,-0.9939,-0.1275,0.9218,1.0105,0.5093,-0.5105,-0.9939,0.1512,0.936,1.0105,0.5093,-0.5105,-0.9939,0.367,1.1382,1.0105,0.5093,-0.5105,-0.9939,0.5742,1.0108,1.0105,0.5093,-0.5105,-0.9939,0.8366,0.9326,1.0105,0.5093,-0.5105,-0.9939,1.0656,0,1),
                 tolerance = 1e-2)
#     cfs <- as.numeric(do.call(c, coef(rsm, verbose = FALSE)))
#     expect_equal(cfs, c(1, 0, 1, 2, 3, 4, 0, -3607.3991, 798.7324, 352.2667, 1218.8, 0, 1, 0, 1, 2, 3, 4, 0, -3607.3991, 798.7324, 352.2667, 1218.8, -182, 1, 0, 1, 2, 3, 4, 0, -3607.3991, 798.7324, 352.2667, 1218.8, -167.2, 1, 0, 1, 2, 3, 4, 0, -3607.3991, 798.7324, 352.2667, 1218.8, -135.4, 1, 0, 1, 2, 3, 4, 0, -3607.3991, 798.7324, 352.2667, 1218.8, -124.4, 1, 0, 1, 2, 3, 4, 0, -3607.3991, 798.7324, 352.2667, 1218.8, -108.6, 1, 0, 1, 2, 3, 4, 0, -3607.3991, 798.7324, 352.2667, 1218.8, -96.2, 1, 0, 1, 2, 3, 4, 0, -3607.3991, 798.7324, 352.2667, 1218.8, -92.4, 1, 0, 1, 2, 3, 4, 0, -3607.3991, 798.7324, 352.2667, 1218.8, -71.8, 1, 0, 1, 2, 3, 4, 0, -3607.3991, 798.7324, 352.2667, 1218.8, -59.2, 0, 1.6093),
#                  tolerance = 1e-2)
#     expect_equal(rsm@df, 9765610)
    expect_equal(extract.mirt(grsm, 'df'), 9765601)
    graded <- mirt(data, 1, verbose = FALSE)
    gM2 <- M2(graded, calcNull=TRUE)
    expect_equal(gM2$M2, 16.68317, tolerance = 1e-4)
    expect_equal(gM2$df, 5)
    expect_equal(gM2$CFI, .9723554, tolerance = 1e-4)
    expect_equal(gM2$SRMSR, 0.01984457, tolerance = 1e-4)

    #item and test info
    Theta <- matrix(seq(-4,4,.01))
    x <- extract.item(modp1, 1)
    iinfo <- iteminfo(x, Theta)
    expect_is(iinfo, 'numeric')
    iinfo <- iteminfo(x, Theta, total.info=FALSE)
    expect_is(iinfo, 'matrix')
    tinfo <- testinfo(modp1, Theta)
    expect_is(tinfo, 'numeric')

    ER <- fscores(modp2, returnER = TRUE)
    expect_equal(as.numeric(ER), c(0.4882546, 0.5099054), tolerance=1e-4)
    suppressWarnings(ER2 <- fscores(modp2, returnER = TRUE, mean = c(-1, 1), cov = matrix(c(1.5,1,1,2), 2)))
    expect_equal(as.numeric(ER2), c(0.3905138, 0.4797115), tolerance=1e-4)
})
