context('mirt.model')

test_that('syntax', {
    data <- expand.table(LSAT7)
    model1 <- mirt.model('F = 1-5')
    model2 <- mirt.model('F = 1-5
                   CONSTRAIN = (1,2,3-5,a1)')
    model3 <- mirt.model('F = 1-5
                   CONSTRAIN = (2,3-5,a1)
                   PRIOR = (2,3-5, a1, lnorm, .2, .2), (1, d, norm, 0, 2)')
    model4 <- mirt.model('F = 1-5
                   CONSTRAIN = (1-2, d)
                   CONSTRAINB = (2-4,5,a1), (1, a1)
                   PRIOR = (1-5, d, norm, 0, 2)')
    model5 <- mirt.model('F = 1-5
                   CONSTRAIN = (1-5, d, male)
                   CONSTRAINB = (1-4,5,a1)
                   PRIOR = (1-5, d, norm, 0, 2, female)')
    model6 <- mirt.model('F1 = 1-2
                         F2 = 3-5
                         CONSTRAIN = (3-5, a2), (1-2, a1)
                         COV = F1*F2')

    set.seed(1234)
    group <- sample(c('male', 'female'), 1000, TRUE)

    mod1 <- mirt(data, model1, verbose=FALSE, calcNull=FALSE)
    mod2 <- mirt(data, model2, verbose=FALSE, calcNull=FALSE)
    mod3 <- mirt(data, model3, verbose=FALSE, calcNull=FALSE)
    mod6 <- mirt(data, model6, verbose=FALSE, calcNull=FALSE)
    mod4 <- multipleGroup(data, model4, group=group, verbose = FALSE)
    mod5 <- multipleGroup(data, model5, group=group, verbose = FALSE)

    expect_equal(mod2values(mod1)$value, c(0.987973787231699, 1.85608912732841, 0, 1, 1.08103954211169, 0.808007534786952, 0, 1, 1.70595475896956, 1.80426768080187, 0, 1, 0.765076394253259, 0.486005938565521, 0, 1, 0.735771996169788, 1.85448564531374, 0, 1, 0, 1),
                 tolerance = 1e-2)
    expect_equal(mod2values(mod2)$value, c(1.01052705474606, 1.86793304554809, 0, 1, 1.01052705474606, 0.790899504740889, 0, 1, 1.01052705474606, 1.46073200902294, 0, 1, 1.01052705474606, 0.521457445159032, 0, 1, 1.01052705474606, 1.99261823763434, 0, 1, 0, 1),
                 tolerance = 1e-2)
    expect_equal(mod2values(mod3)$value, c(1.10784174676958, 1.91239633478765, 0, 1, 1.04684043398884, 0.797880409701628, 0, 1, 1.04684043398884, 1.47310584064986, 0, 1, 1.04684043398884, 0.526104887330641, 0, 1, 1.04684043398884, 2.00877254688793, 0, 1, 0, 1),
                 tolerance = 1e-2)
    expect_equal(mod2values(mod4)$value, c(0.632433386364048, 1.49702486346345, 0, 1, 2.96489722606489, 1.49702486346345, 0, 1, 1.18479385862914, 1.64385966616173, 0, 1, 0.559375636820039, 0.546379939983741, 0, 1, 0.503248507572237, 1.69989443532475, 0, 1, 0, 1, 0.632433386364048, 1.72304362449882, 0, 1, 2.96489722606489, 1.72304362449882, 0, 1, 1.18479385862914, 1.49301755218875, 0, 1, 0.559375636820039, 0.411003355734207, 0, 1, 0.503248507572237, 1.84027620095569, 0, 1, 0, 1),
                 tolerance = 1e-2)
    expect_equal(mod2values(mod5)$value, c(0.737129505226237, 1.35704143060501, 0, 1, 1.48520300345399, 1.35704143060501, 0, 1, 1.05934883550827, 1.35704143060501, 0, 1, 1.27305097103351, 1.35704143060501, 0, 1, 0.471202089414926, 1.35704143060501, 0, 1, 0, 1, 0.737129505226237, 1.86332806707802, 0, 1, 1.48520300345399, 0.949841783215661, 0, 1, 1.05934883550827, 1.39297918257708, 0, 1, 1.27305097103351, 0.472956611691705, 0, 1, 0.471202089414926, 1.81137826788352, 0, 1, 0, 1),
                 tolerance = 1e-2)
    expect_equal(mod2values(mod6)$value, c(1.0903077932694, 0, 1.91140861863278, 0, 1, 1.0903077932694, 0, 0.810348254879057, 0, 1, 0, 1.0101813883046, 1.46075728200956, 0, 1, 0, 1.0101813883046, 0.521336672537102, 0, 1, 0, 1.0101813883046, 1.99270549803447, 0, 1, 0, 0, 1, 0.911175950866077, 1),
                 tolerance = 1e-2)
    
    data(data.read, package = 'sirt')
    dat <- data.read
     
    # syntax with variable names
    mirtsyn2 <- "
            F1 = A1,B2,B3,C4
            F2 = A1-A4,C2,C4
            MEAN = F1 
            COV = F1*F1, F1*F2
            CONSTRAIN=(A2-A4,a2),(A3,C2,d)
            PRIOR = (C3,A2-A4,a2,lnorm, .2, .2),(B3,d,norm,0,.0001)"
    # create a mirt model            
    mirtmodel <- mirt.model(mirtsyn2, itemnames=dat)
    # or equivelently: 
    mirtmodel2 <- mirt.model(mirtsyn2, itemnames=colnames(dat))
    
    expect_true(all(mirtmodel$x == mirtmodel2$x))
    got <- matrix(c(c('F1', 'F2', "MEAN", 'COV', 'CONSTRAIN', 'PRIOR'), 
                    c("1,6,7,12", "1-4,10,12","F1","F1*F1,F1*F2","(2-4,a2),(3,10,d)",
                      "(11,2-4,a2,lnorm,.2,.2),(7,d,norm,0,.0001)")), nrow = 6)
    expect_true(all(mirtmodel$x == got))
    
})

