% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mise.R
\name{mise}
\alias{mise}
\title{Clear the Workspace (Mise en Place)}
\usage{
mise(vars = TRUE, figs = TRUE, console = TRUE, pkgs = FALSE)
}
\arguments{
\item{vars}{clear all variables and functions in the parent environment?}

\item{figs}{close all figure windows?}

\item{console}{clear the console?}

\item{pkgs}{clear all non-base packages?  Defaults to FALSE.}
}
\description{
Clears the workspace.  Useful for the beginnings of R scripts, to
avoid potential problems with accidentally using information from
variables or functions from previous script evaluations, too many
figure windows open at the same time, packages that you don't
need any more, or a cluttered console.
}
\details{
Based on StackOverflow contributions from users David Robinson,
shadow, Gavin Simpson, Ramnath, Joshua Ulrich, E Luxo So,
and krlmlr; see
http://stackoverflow.com/questions/29758000/function-to-remove-all-variables
http://stackoverflow.com/questions/19449066/command-to-close-plots-in-r
http://stackoverflow.com/questions/7505547/detach-all-packages-while-working-in-r
http://stackoverflow.com/questions/12389158/check-if-r-is-running-in-rstudio
l
}
\examples{
library(mise)
x <- seq(1, 10, by = 1)
y <- x+ rnorm(10, mean = 0, sd = 1)
plot(x, y)
ls()
# change figs to TRUE to also clear the figure
mise(figs = FALSE)
ls()
}
\keyword{clear}
\keyword{detach,}
\keyword{graphics.off(),}
\keyword{rm,}

