% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{md.survcox}
\alias{md.survcox}
\title{Fit a proportional hazards regression model over disease recurrence data 
with missing information of possible deaths}
\usage{
md.survcox(data, f, maxtime, D, ratetable, iterations = 4, R = 50)
}
\arguments{
\item{data}{a data.frame in which to interpret the variables named in the
formula.}

\item{f}{a formula object, with the response on the left of a ~ operator,
and the terms on the right. The response must be a survival object as
returned by the \code{Surv} function.}

\item{maxtime}{maximum potential observation time (number of days).

where \code{status}=0 equals \code{time}.

where \code{status}=1 equals potential time of right censoring if no event
would be observed.}

\item{D}{demographic information compatible with \code{ratetable}, see
\code{\link{md.D}}.}

\item{ratetable}{a population mortality table, default is \code{slopop}}

\item{iterations}{the number of iteration steps to be performed, default is
4}

\item{R}{the number of multiple imputations performed to adjust the
estimated variance of estimates, default is 50.}
}
\value{
if \code{R} equals 1 then an object of class
\code{\link[survival]{coxph.object}} representing the fit.

if \code{R} > 1 then the result of the \code{\link[mitools]{MIcombine}} of
the \code{coxph} objects.
}
\description{
An iterative approach is used in this method to estimate the conditional
distribution required to correctly impute the times of deaths using
population mortality tables.\cr\cr
  Note, that simply imputing expected survival times may seem intuitive, 
but does not give unbiased estimates, since the right censored individuals 
are not a random subsample of the patients.
}
\examples{

\dontrun{
library(missDeaths)
data(slopop)

data(observed)
observed$time = observed$time*365.2425
D = md.D(age=observed$age*365.2425, sex=observed$sex, year=(observed$year - 1960)*365.2425)

#fit a cox model (NOTE: estimated std error is slightly underestimated!)
md.survcox(observed, Surv(time, status) ~ age + sex + iq + elevation, 
  observed$maxtime*365.2425, D, slopop, iterations=4, R=1)

#multiple imputations to correct the stimated std error
md.survcox(observed, Surv(time, status) ~ age + sex + iq + elevation, 
  observed$maxtime*365.2425, D, slopop, iterations=4, R=50)
}

}
\references{
Stupnik T., Pohar Perme M. (2015) "Analysing disease recurrence
with missing at risk information." Statistics in Medicine 35. p1130-43.
\url{http://onlinelibrary.wiley.com/doi/10.1002/sim.6766/abstract}
}
\seealso{
\code{\link{md.impute}}, \code{\link[mitools]{MIcombine}}
}

