% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateNA.R
\name{generateNA}
\alias{generateNA}
\title{Adds Missing Values}
\usage{
generateNA(x, p = 0.1, seed = NULL)
}
\arguments{
\item{x}{A vector, matrix or \code{data.frame}.}

\item{p}{Proportion of missing values to add to \code{x}. In case \code{x} is a \code{data.frame},
\code{p} can also be a vector of probabilities per column or a named vector
(see examples).}

\item{seed}{An integer seed.}
}
\value{
\code{x} with missing values.
}
\description{
Takes a vector, matrix or \code{data.frame} and replaces some values by \code{NA}.
}
\examples{
generateNA(1:10, p = 0.5, seed = 3345)
generateNA(rep(Sys.Date(), 10))
generateNA(cbind(1:10, 10:1), p = 0.2)
head(generateNA(iris))
head(generateNA(iris, p = 0.2))
head(generateNA(iris, p = c(0, 1, 0.5, 0.5, 0.5)))
head(generateNA(iris, p = c(Sepal.Length = 1)))
head(generateNA(iris, p = c(Species = 0.2, Sepal.Length = 0.5)))
}
