% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputeUnivariate.R
\name{imputeUnivariate}
\alias{imputeUnivariate}
\title{Univariate Imputation}
\usage{
imputeUnivariate(x, v = NULL, seed = NULL)
}
\arguments{
\item{x}{A vector, matrix or data frame.}

\item{v}{A character vector of column names to impute (only relevant if \code{x}
is a data frame). The default \code{NULL} imputes all columns.}

\item{seed}{An integer seed.}
}
\value{
\code{x} with imputed values.
}
\description{
Fills missing values of a vector, matrix or data frame by sampling with replacement
from the non-missing values. For data frames, this sampling is done within column.
}
\examples{
imputeUnivariate(c(NA, 0, 1, 0, 1))
head(imputeUnivariate(generateNA(iris)))
}
