% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mgsub.R
\name{mgsub}
\alias{mgsub}
\title{Multiple Pattern Matching And Replacements}
\usage{
mgsub(pattern, replacement, x, recycle = FALSE, ...)
}
\arguments{
\item{pattern}{a character vector with character strings to be matched.}

\item{replacement}{a character vector equal in length to \code{pattern} or of
length one which are a replacement for matched patterns.}

\item{x}{a character vector where matches and replacements are sought.}

\item{recycle}{logical: if \code{TRUE}, replacement is recycled if lengths differ.}

\item{...}{additional arguments to pass to the \code{regexpr} or \code{sub}
function.}
}
\value{
Return a character vector of the same length and with the same attributes as \code{x} (after
possible coercion to character).
}
\description{
This function is a multiple global string replacement wrapper that allows access to
multiple methods of specifying matches and replacements.
}
\details{
Note that the function was adapted from the \code{mgsub()} function in the \pkg{mgsub}
package by Mark Ewing (2019).
}
\examples{
string <- c("hey ho, let's go!")
mgsub(c("hey", "ho"), c("ho", "hey"), string)

string <- "they don't understand the value of what they seek."
mgsub(c("the", "they"), c("a", "we"), string)

string <- c("hey ho, let's go!")
mgsub(c("hey", "ho"), "yo", string, recycle = TRUE)

string <- "Dopazamine is not the same as dopachloride or dopastriamine, yet is still fake."
mgsub(c("[Dd]opa([^ ]*?mine)","fake"), c("Meta\\\\1","real"), string)
}
\references{
Mark Ewing (2019). \emph{mgsub: Safe, Multiple, Simultaneous String Substitution}. R package
version 1.7.1. https://CRAN.R-project.org/package=mgsub
}
\seealso{
\code{\link{stromit}}, \code{\link{trim}}
}
\author{
Mark Ewing
}
