% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.result.R
\name{write.result}
\alias{write.result}
\title{Write Results of a misty Object into an Excel file}
\usage{
write.result(x, file = "Results.xlsx", tri = x$args$tri,
             digits = x$args$digits, p.digits = x$args$p.digits,
             icc.digits = x$args$icc.digits, r.digits = x$args$r.digits,
             ess.digits = x$args$ess.digits, mcse.digits = x$args$mcse.digits,
             check = TRUE)
}
\arguments{
\item{x}{misty object (\code{misty.object}) resulting from a misty function
supported by the \code{write.result} function (see 'Details').}

\item{file}{a character string naming a file with or without file extension
'.xlsx', e.g., \code{"Results.xlsx"} or \code{"Results"}.}

\item{tri}{a character string or character vector indicating which triangular
of the matrix to show on the console, i.e., \code{both} for upper and lower
triangular, \code{lower} for the lower triangular, and \code{upper} for the upper
triangular.}

\item{digits}{an integer value indicating the number of decimal places digits
to be used for displaying results.}

\item{p.digits}{an integer indicating the number of decimal places to be used
for displaying \emph{p}-values.}

\item{icc.digits}{an integer indicating the number of decimal places to be used
for displaying intraclass correlation coefficients.}

\item{r.digits}{an integer value indicating the number of decimal places
to be used for displaying R-hat values.}

\item{ess.digits}{an integer value indicating the number of decimal places
to be used for displaying effective sample sizes.}

\item{mcse.digits}{an integer value indicating the number of decimal places
to be used for displaying Monte Carlo standard errors.}

\item{check}{logical: if \code{TRUE} (default), argument specification is checked.}
}
\description{
This function writes the results of a \code{misty.object}) into an Excel file.
}
\details{
Currently the function supports result objects from the following functions:
\code{\link{blimp.bayes}}, \code{\link{ci.cor}}, \code{\link{ci.mean}},
\code{\link{ci.median}}, \code{\link{ci.prop}}, \code{\link{ci.var}},
\code{\link{ci.sd}}, \code{\link{coeff.robust}}, \code{\link{coeff.std}},
\code{\link{cor.matrix}}, \code{\link{crosstab}}, \code{\link{descript}},
\code{\link{dominance.manual}}, \code{\link{dominance}}, \code{\link{effsize}},
\code{\link{freq}}, \code{\link{item.alpha}}, \code{\link{item.cfa}},
\code{\link{item.invar}}, \code{\link{item.omega}}, \code{\link{mplus.bayes}},
\code{\link{multilevel.cfa}}, \code{\link{multilevel.cor}},
\code{\link{multilevel.descript}}, \code{\link{multilevel.fit}},
\code{\link{multilevel.invar}}, \code{\link{multilevel.omega}},
\code{\link{na.auxiliary}}, \code{\link{na.coverage}}, \code{\link{na.descript}},
\code{\link{na.pattern}}, \code{\link{result.lca}},
\code{\link{summa}} and \code{\link{uniq}}
}
\examples{
\dontrun{
#----------------------------------------------------------------------------
# Example 1: item.cfa() function

# Load data set "HolzingerSwineford1939" in the lavaan package
data("HolzingerSwineford1939", package = "lavaan")

result <- item.cfa(HolzingerSwineford1939[, c("x1", "x2", "x3")], output = FALSE)
write.result(result, "CFA.xlsx")

#----------------------------------------------------------------------------
# Example 2: multilevel.descript() function

# Load data set "Demo.twolevel" in the lavaan package
data("Demo.twolevel", package = "lavaan")

result <- multilevel.descript(y1:y3, data = Demo.twolevel, cluster = "cluster",
                              output = FALSE)
write.result(result, "Multilevel_Descript.xlsx")
}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
