\name{unmap}
\alias{unmap}
\title{
  Dummy matrix for an outcome factor
}
\description{
  Converts a class or group vector or factor into a matrix of indicator variables. 
}
\usage{
  unmap(classification, groups=NULL, noise=NULL)
}
\arguments{
  \item{classification}{
    A numeric or character vector or factor. Typically the distinct entries of this
    vector would represent a classification of observations in a data set.
  }
  \item{groups}{
    A numeric or character vector indicating the groups from which
    \code{classification} is drawn. If not supplied, the default
    is to assumed to be the unique entries of classification.
  }
  \item{noise}{
    A single numeric or character value used to indicate the value of
    \code{groups} corresponding to noise.
}
}
\value{
  An \emph{n} by \emph{K} matrix of \emph{(0,1)} indicator variables,
  where \emph{n} is the length of samples and \emph{K} the number of classes in the outcome.  

  If a \code{noise} value of symbol is designated, the corresponding indicator 
  variables are relocated to the last column of the matrix. 
  
  Note: 
  - you can remap an unmap vector using the function \code{map} from the package \pkg{mclust}.
  - this function should be used to unmap an outcome vector as in the non-supervised methods of mixOmics. For other supervised analyses such as (s)PLS-DA, (s)gccaDA this function is used internally.
}
\section{References}{
  C. Fraley and A. E. Raftery (2002).
  Model-based clustering, discriminant analysis, and density estimation.
  \emph{Journal of the American Statistical Association 97:611-631}. 
  
  C. Fraley, A. E. Raftery, T. B. Murphy and L. Scrucca (2012).
  mclust Version 4 for R: Normal Mixture Modeling for Model-Based 
  Clustering, Classification, and Density Estimation. 
  Technical Report No. 597, Department of Statistics, University of Washington.
}

\examples{
data(nutrimouse)
Y = unmap(nutrimouse$diet)
Y
data = list(gene = nutrimouse$gene, lipid = nutrimouse$lipid, Y = Y)
# data could then used as an input in wrapper.rgcca, which is not, technically, 
# a supervised method, see ??wrapper.rgcca
}
\keyword{cluster}
% docclass is function
% Converted by Sd2Rd version 1.21.
