% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmixnormal.R
\name{rmixnormal}
\alias{rmixnormal}
\title{Generating Random Data From A Normal Mixture Model}
\usage{
rmixnormal(n, pi, mu, sd)
}
\arguments{
\item{n}{a positive integer specifying the number of observations we want to generate from the mixture model}

\item{pi}{a numeric vector for the proportion of each component}

\item{mu}{a numeric vector for the mean of each component}

\item{sd}{a numeric vector for the standard deviation of each component}
}
\value{
The function \code{rmixnormal} returns a numeric vector of random data from the specified normal mixture model.
}
\description{
The function \code{rmixnormal} generates random data from a normal mixture model.
}
\details{
The number of random data from each component \eqn{n_0} (a vector) is generated from a multinomial
distribution Multinom\eqn{(n, pi)}. Then the random data from each component is generated with
the sample sized specified in \eqn{n_0} and parameters of normal distributions specified in
\code{mu} and \code{sd}.
}
\examples{
x <- rmixnormal(1000, c(0.4, 0.6), c(2, 5), c(1, 0.5))
hist(x, breaks = 40)

}
\seealso{
\code{\link{rmixweibull}}, \code{\link{rmixgamma}}, \code{\link{rmixlnorm}}
}
