\name{expdat}
\alias{expdat}
\title{A Mixture Data of Three Exponential Distributions}
\usage{data(expdat)}
\description{
A total of 1000 observations was generated by computer to follow the mixture distribution 
1/3 E(1) + 1/3 E(4) + 1/3 E(16) where E(\emph{m}) denotes an exponential distribution with mean \emph{m}.

The \code{expdat} data frame has 25 rows and 2 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{x}{the boundaries of grouping intervals.}
    \item{freq}{the frequencies of observation falling into each interval.}
  }
}
\source{
  Macdonald, P.D.M. and Green, P.E.J. (1988) \emph{User's Guide to Program MIX: 
  An Interactive Program for Fitting Mixtures of Distributions.} ICHTHUS DATA
  SYSTEMS.
}
\references{
  Macdonald, P.D.M. and Green, P.E.J. (1988) \emph{User's Guide to Program MIX: 
  An Interactive Program for Fitting Mixtures of Distributions.} ICHTHUS DATA
  SYSTEMS.
  
  \url{http://www.math.mcmaster.ca/peter/mix/demex/exexp.html}
}
\examples{
data(expdat)
plot.mixdata(expdat)
}
\keyword{datasets}
