% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vlmc_contexts.R
\name{contexts.vlmc}
\alias{contexts.vlmc}
\title{Contexts of a VLMC}
\usage{
\method{contexts}{vlmc}(
  ct,
  type = c("auto", "list", "data.frame"),
  reverse = TRUE,
  frequency = NULL,
  counts = c("desc", "local"),
  cutoff = NULL,
  metrics = FALSE,
  ...
)
}
\arguments{
\item{ct}{a context tree.}

\item{type}{result type (see details).}

\item{reverse}{logical (defaults to FALSE). See details.}

\item{frequency}{specifies the counts to be included in the result
data.frame. The default value of \code{NULL} does not include anything.
\code{"total"} gives the number of occurrences of each context in the original
sequence. \code{"detailed"} includes in addition the break down of these
occurrences into all the possible states.}

\item{counts}{specifies how the counts reported by \code{frequency} are computed.
The default value \code{"desc"} includes both counts that are specific to the
context (if any) and counts from the descendants of the context in the
tree. When \code{counts = "local"} the counts include only the number of times
the context appears without being the last part of a longer context.}

\item{cutoff}{specifies whether to include the cut off value associated to
each context (see \code{\link[=cutoff]{cutoff()}} and \code{\link[=prune]{prune()}}). The default result with
\code{cutoff=NULL} does not include those values. Setting \code{cutoff} to \code{quantile}
adds the cut off values in quantile scale, while \code{cutoff="native"} adds
them in the native scale. The returned values are directly based on the
log likelihood ratio computed in the context tree and are not modified to
ensure pruning (as when \code{\link[=cutoff]{cutoff()}} is called by  \code{raw=TRUE}).}

\item{metrics}{if TRUE, adds predictive metrics for each context (see \code{\link[=metrics]{metrics()}}
for the definition of predictive metrics).}

\item{...}{additional arguments for the contexts function.}
}
\value{
The list of the contexts represented in this tree or a data.frame
with more content.
}
\description{
This function extracts all the contexts from a fitted VLMC, possibly with
some associated data.
}
\details{
The default result for \code{type="auto"} (or \code{type="list"}),
\code{frequency=NULL}, \code{cutoff=NULL} and \code{metrics=FALSE} is the list of all contexts.

Other results are obtained only with \code{type="auto"} or \code{type="data.frame"}.
See \code{\link[=contexts.ctx_tree]{contexts.ctx_tree()}} for details about the \code{frequency} parameter. When
\code{cutoff} is non \code{NULL}, the resulting \code{data.frame} contains a \code{cutoff}
column with the cut off values, either in quantile or in native scale. See
\code{\link[=cutoff]{cutoff()}} and \code{\link[=prune]{prune()}} for the definitions of cut off values and of the
two scales.
}
\section{Cut off values}{
 The cut off values reported by \code{contexts.vlmc} can
be different from the ones reported by \code{\link[=cutoff]{cutoff()}} for three reasons:
\enumerate{
\item \code{\link[=cutoff]{cutoff()}} reports only useful cut off values, i.e., cut off values that
should induce a simplification of the VLMC when used in \code{\link[=prune]{prune()}}. This
exclude cut off values associated to simple contexts that are smaller than
the ones of their descendants in the context tree. Those values are
reported by \code{context.vlmc}.
\item \code{context.vlmc} reports only cut off values of actual contexts, while
\code{\link[=cutoff]{cutoff()}} reports cut off values for all nodes of the context tree.
\item values are not modified to induce pruning, contrarily to the default
behaviour of \code{\link[=cutoff]{cutoff()}}
}
}

\section{State order in a context}{
 Notice that contexts are given by default
in the "reverse" order used by the VLMC papers: older values are on the
right. For instance, the context \code{c(0, 1)} is reported if the sequence 1,
then 0 appeared in the time series used to build the context tree. Set
reverse to \code{FALSE} for the reverse convention.
}

\examples{
dts <- sample(as.factor(c("A", "B", "C")), 100, replace = TRUE)
model <- vlmc(dts, alpha = 0.5)
contexts(model)
contexts(model, frequency = "total")
contexts(model, cutoff = "quantile")
}
\seealso{
\code{\link[=contexts.ctx_tree]{contexts.ctx_tree()}}, \code{\link[=contexts.vlmc]{contexts.vlmc()}}, \code{\link[=contexts.covlmc]{contexts.covlmc()}}.
}
