% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MizerParams-class.R
\name{emptyParams}
\alias{emptyParams}
\title{Create empty MizerParams object of the right size}
\usage{
emptyParams(
  species_params,
  gear_params = data.frame(),
  no_w = 100,
  min_w = 0.001,
  max_w = NA,
  min_w_pp = 1e-12
)
}
\arguments{
\item{species_params}{A data frame of species-specific parameter values.}

\item{gear_params}{A data frame with gear-specific parameter values.}

\item{no_w}{The number of size bins in the consumer spectrum.}

\item{min_w}{Sets the size of the eggs of all species for which this is not
given in the \code{w_min} column of the \code{species_params} dataframe.}

\item{max_w}{The largest size of the consumer spectrum. By default this is
set to the largest \code{w_inf} specified in the \code{species_params} data
frame.}

\item{min_w_pp}{The smallest size of the resource spectrum.}
}
\value{
An empty but valid MizerParams object
}
\description{
An internal function.
Sets up a valid \linkS4class{MizerParams} object with all the slots
initialised and given dimension names, but with some slots left empty. This
function is to be used by other functions to set up full parameter objects.
}
\section{Size grid}{

A size grid is created so that
the log-sizes are equally spaced. The spacing is chosen so that there will be
\code{no_w} fish size bins, with the smallest starting at \code{min_w} and the largest
starting at \code{max_w}. For \code{w_full} additional size bins are added below
\code{min_w}, with the same log size. The number of extra bins is such that
\code{min_w_pp} comes to lie within the smallest bin.
}

\section{Changes to species params}{

The \code{species_params} slot of the returned MizerParams object may differ
slightly from the data frame supplied as argument to this function because
default values are set for
\verb{w_min, w_inf, alpha, gear, interaction_resource}.
}

\seealso{
See \code{\link[=newMultispeciesParams]{newMultispeciesParams()}} for a function that fills
the slots left empty by this function.
}
